/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.input;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.PovDirection;
import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.GamePadListener;
import org.mini2Dx.core.input.GamePadType;
import org.mini2Dx.core.input.PovState;
import org.mini2Dx.core.input.ps4.PS4GamePad;
import org.mini2Dx.core.input.xbox.XboxGamePad;
import org.mini2Dx.gdx.math.Vector3;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.IntFloatMap;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.gdx.utils.IntSet;

public class LibgdxGamePad
implements GamePad,
ControllerListener {
    private final Controller controller;
    private final Array<GamePadListener> listeners = new Array();
    private final IntSet downButtons = new IntSet();
    private final IntFloatMap axes = new IntFloatMap();
    private final IntMap<PovState> povs = new IntMap();
    private final IntMap<Vector3> accelerometers = new IntMap();
    protected GamePadType gamePadType = null;
    protected boolean connected = true;

    public LibgdxGamePad(Controller controller) {
        this.controller = controller;
    }

    public void init() {
        this.controller.addListener((ControllerListener)this);
    }

    public void connected(Controller controller) {
        this.connected = true;
        this.notifyConnected();
    }

    public void disconnected(Controller controller) {
        this.connected = false;
        this.notifyDisconnected();
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        this.downButtons.add(buttonCode);
        this.notifyButtonDown(buttonCode);
        return true;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        this.downButtons.remove(buttonCode);
        this.notifyButtonUp(buttonCode);
        return true;
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        this.axes.put(axisCode, value);
        this.notifyAxisChanged(axisCode, value);
        return true;
    }

    public boolean povMoved(Controller controller, int povCode, PovDirection value) {
        switch (value) {
            case center: {
                this.povs.put(povCode, (Object)PovState.CENTER);
                break;
            }
            case north: {
                this.povs.put(povCode, (Object)PovState.NORTH);
                break;
            }
            case south: {
                this.povs.put(povCode, (Object)PovState.SOUTH);
                break;
            }
            case east: {
                this.povs.put(povCode, (Object)PovState.EAST);
                break;
            }
            case west: {
                this.povs.put(povCode, (Object)PovState.WEST);
                break;
            }
            case northEast: {
                this.povs.put(povCode, (Object)PovState.NORTH_EAST);
                break;
            }
            case southEast: {
                this.povs.put(povCode, (Object)PovState.SOUTH_EAST);
                break;
            }
            case northWest: {
                this.povs.put(povCode, (Object)PovState.NORTH_WEST);
                break;
            }
            case southWest: {
                this.povs.put(povCode, (Object)PovState.SOUTH_WEST);
            }
        }
        this.notifyPovChanged(povCode, (PovState)this.povs.get(povCode, (Object)PovState.CENTER));
        return true;
    }

    public boolean xSliderMoved(Controller controller, int sliderCode, boolean value) {
        return true;
    }

    public boolean ySliderMoved(Controller controller, int sliderCode, boolean value) {
        return true;
    }

    public boolean accelerometerMoved(Controller controller, int accelerometerCode, com.badlogic.gdx.math.Vector3 value) {
        if (!this.accelerometers.containsKey(accelerometerCode)) {
            this.accelerometers.put(accelerometerCode, (Object)new Vector3(value.x, value.y, value.z));
        } else {
            ((Vector3)this.accelerometers.get(accelerometerCode)).set(value.x, value.y, value.z);
        }
        this.notifyAccelerometerChanged(accelerometerCode);
        return true;
    }

    public GamePadType getGamePadType() {
        if (this.gamePadType == null) {
            int i;
            String name = this.controller.getName().toLowerCase();
            for (i = 0; i < XboxGamePad.ID.length; ++i) {
                if (!name.contains(XboxGamePad.ID[i])) continue;
                this.gamePadType = GamePadType.XBOX;
                return GamePadType.XBOX;
            }
            for (i = 0; i < PS4GamePad.ID.length; ++i) {
                if (!name.contains(PS4GamePad.ID[i])) continue;
                this.gamePadType = GamePadType.PS4;
                return GamePadType.PS4;
            }
            this.gamePadType = GamePadType.UNKNOWN;
        }
        return this.gamePadType;
    }

    public String getInstanceId() {
        return this.controller.getName();
    }

    public String getModelInfo() {
        return this.controller.getName();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isButtonDown(int buttonCode) {
        return this.downButtons.contains(buttonCode);
    }

    public boolean isButtonUp(int buttonCode) {
        return !this.downButtons.contains(buttonCode);
    }

    public float getAxis(int axisCode) {
        return this.axes.get(axisCode, 0.0f);
    }

    public PovState getPov(int povCode) {
        return (PovState)this.povs.get(povCode, (Object)PovState.CENTER);
    }

    public boolean isAccelerometerSupported() {
        return false;
    }

    public Vector3 getAccelerometer(int accelerometerCode) {
        if (!this.accelerometers.containsKey(accelerometerCode)) {
            this.accelerometers.put(accelerometerCode, (Object)new Vector3(Vector3.Zero));
        }
        return (Vector3)this.accelerometers.get(accelerometerCode);
    }

    public float getAccelerometerSensitivity() {
        return 0.0f;
    }

    public void setAccelerometerSensitivity(float sensitivity) {
    }

    public void addListener(GamePadListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(GamePadListener listener) {
        this.listeners.removeValue((Object)listener, false);
    }

    protected void notifyConnected() {
        for (int i = this.listeners.size - 1; i >= 0; --i) {
            ((GamePadListener)this.listeners.get(i)).onConnect((GamePad)this);
        }
    }

    protected void notifyDisconnected() {
        for (int i = this.listeners.size - 1; i >= 0; --i) {
            ((GamePadListener)this.listeners.get(i)).onDisconnect((GamePad)this);
        }
    }

    protected void notifyButtonDown(int buttonCode) {
        for (int i = this.listeners.size - 1; i >= 0; --i) {
            ((GamePadListener)this.listeners.get(i)).onButtonDown((GamePad)this, buttonCode);
        }
    }

    protected void notifyButtonUp(int buttonCode) {
        for (int i = this.listeners.size - 1; i >= 0; --i) {
            ((GamePadListener)this.listeners.get(i)).onButtonUp((GamePad)this, buttonCode);
        }
    }

    protected void notifyPovChanged(int povCode, PovState state) {
        for (int i = this.listeners.size - 1; i >= 0; --i) {
            ((GamePadListener)this.listeners.get(i)).onPovChanged((GamePad)this, povCode, state);
        }
    }

    protected void notifyAxisChanged(int axisCode, float axisValue) {
        for (int i = this.listeners.size - 1; i >= 0; --i) {
            ((GamePadListener)this.listeners.get(i)).onAxisChanged((GamePad)this, axisCode, axisValue);
        }
    }

    protected void notifyAccelerometerChanged(int accelerometerCode) {
        for (int i = this.listeners.size - 1; i >= 0; --i) {
            ((GamePadListener)this.listeners.get(i)).onAccelerometerChanged((GamePad)this, accelerometerCode, (Vector3)this.accelerometers.get(accelerometerCode));
        }
    }

    public boolean isPlayerIndicesSupported() {
        return false;
    }

    public int getPlayerIndex() {
        return -1;
    }

    public void setPlayerIndex(int playerIndex) {
    }

    public boolean isVibrateSupported() {
        return false;
    }

    public boolean isVibrating() {
        return false;
    }

    public float getVibrationStrength() {
        return 0.0f;
    }

    public void startVibration(float strength) {
    }

    public void stopVibration() {
    }
}

