/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.input;

import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.PovState;
import org.mini2Dx.core.input.button.PS4Button;
import org.mini2Dx.core.input.deadzone.DeadZone;
import org.mini2Dx.core.input.ps4.PS4GamePad;
import org.mini2Dx.gdx.math.Vector3;
import org.mini2Dx.gdx.utils.IntMap;

public class LibgdxPS4GamePad
extends PS4GamePad {
    private static final int LEFT_STICK_X = 0;
    private static final int LEFT_STICK_Y = 1;
    private static final int RIGHT_STICK_X = 2;
    private static final int RIGHT_STICK_Y = 3;
    private static final int L2 = 4;
    private static final int R2 = 5;
    private static final IntMap<PS4Button> BUTTON_MAPPINGS = new IntMap<PS4Button>(){
        {
            this.put(0, PS4Button.CROSS);
            this.put(1, PS4Button.CIRCLE);
            this.put(2, PS4Button.SQUARE);
            this.put(3, PS4Button.TRIANGLE);
            this.put(4, PS4Button.TOUCHPAD);
            this.put(5, PS4Button.PS);
            this.put(6, PS4Button.OPTIONS);
            this.put(7, PS4Button.L3);
            this.put(8, PS4Button.R3);
            this.put(9, PS4Button.L1);
            this.put(10, PS4Button.R1);
            this.put(11, PS4Button.UP);
            this.put(12, PS4Button.DOWN);
            this.put(13, PS4Button.LEFT);
            this.put(14, PS4Button.RIGHT);
        }
    };

    public LibgdxPS4GamePad(GamePad gamePad) {
        super(gamePad);
    }

    public LibgdxPS4GamePad(GamePad gamePad, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        super(gamePad, leftStickDeadZone, rightStickDeadZone);
    }

    public void onConnect(GamePad gamePad) {
        this.notifyConnected();
    }

    public void onDisconnect(GamePad gamePad) {
        this.notifyDisconnected();
    }

    public void onButtonDown(GamePad gamePad, int buttonCode) {
        if (!BUTTON_MAPPINGS.containsKey(buttonCode)) {
            return;
        }
        this.notifyButtonDown((PS4Button)BUTTON_MAPPINGS.get(buttonCode));
    }

    public void onButtonUp(GamePad gamePad, int buttonCode) {
        if (!BUTTON_MAPPINGS.containsKey(buttonCode)) {
            return;
        }
        this.notifyButtonUp((PS4Button)BUTTON_MAPPINGS.get(buttonCode));
    }

    public void onPovChanged(GamePad gamePad, int povCode, PovState povState) {
    }

    public void onAxisChanged(GamePad gamePad, int axisCode, float axisValue) {
        switch (axisCode) {
            case 0: {
                this.notifyLeftStickXMoved(axisValue);
                break;
            }
            case 1: {
                this.notifyLeftStickYMoved(axisValue);
                break;
            }
            case 2: {
                this.notifyRightStickXMoved(axisValue);
                break;
            }
            case 3: {
                this.notifyRightStickYMoved(axisValue);
                break;
            }
            case 4: {
                this.notifyL2Moved(axisValue);
                break;
            }
            case 5: {
                this.notifyR2Moved(axisValue);
            }
        }
    }

    public void onAccelerometerChanged(GamePad gamePad, int accelerometerCode, Vector3 value) {
    }
}

