/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.input;

import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.PovState;
import org.mini2Dx.core.input.button.XboxButton;
import org.mini2Dx.core.input.deadzone.DeadZone;
import org.mini2Dx.core.input.xbox.XboxGamePad;
import org.mini2Dx.gdx.math.Vector3;
import org.mini2Dx.gdx.utils.IntMap;

public class LibgdxXboxGamePad
extends XboxGamePad {
    private static final int LEFT_STICK_X = 0;
    private static final int LEFT_STICK_Y = 1;
    private static final int RIGHT_STICK_X = 2;
    private static final int RIGHT_STICK_Y = 3;
    private static final int LEFT_TRIGGER = 4;
    private static final int RIGHT_TRIGGER = 5;
    private static final IntMap<XboxButton> BUTTON_MAPPINGS = new IntMap<XboxButton>(){
        {
            this.put(0, XboxButton.A);
            this.put(1, XboxButton.B);
            this.put(2, XboxButton.X);
            this.put(3, XboxButton.Y);
            this.put(4, XboxButton.BACK);
            this.put(5, XboxButton.GUIDE);
            this.put(6, XboxButton.START);
            this.put(7, XboxButton.LEFT_STICK);
            this.put(8, XboxButton.RIGHT_STICK);
            this.put(9, XboxButton.LEFT_SHOULDER);
            this.put(10, XboxButton.RIGHT_SHOULDER);
            this.put(11, XboxButton.UP);
            this.put(12, XboxButton.DOWN);
            this.put(13, XboxButton.LEFT);
            this.put(14, XboxButton.RIGHT);
        }
    };

    public LibgdxXboxGamePad(GamePad gamePad) {
        super(gamePad);
    }

    public LibgdxXboxGamePad(GamePad gamePad, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        super(gamePad, leftStickDeadZone, rightStickDeadZone);
    }

    public void onConnect(GamePad gamePad) {
        this.notifyConnected();
    }

    public void onDisconnect(GamePad gamePad) {
        this.notifyDisconnected();
    }

    public void onButtonDown(GamePad gamePad, int buttonCode) {
        if (!BUTTON_MAPPINGS.containsKey(buttonCode)) {
            return;
        }
        this.notifyButtonDown((XboxButton)BUTTON_MAPPINGS.get(buttonCode));
    }

    public void onButtonUp(GamePad gamePad, int buttonCode) {
        if (!BUTTON_MAPPINGS.containsKey(buttonCode)) {
            return;
        }
        this.notifyButtonUp((XboxButton)BUTTON_MAPPINGS.get(buttonCode));
    }

    public void onPovChanged(GamePad gamePad, int povCode, PovState povState) {
    }

    public void onAxisChanged(GamePad gamePad, int axisCode, float axisValue) {
        switch (axisCode) {
            case 0: {
                this.notifyLeftStickXMoved(axisValue);
                break;
            }
            case 1: {
                this.notifyLeftStickYMoved(axisValue);
                break;
            }
            case 2: {
                this.notifyRightStickXMoved(axisValue);
                break;
            }
            case 3: {
                this.notifyRightStickYMoved(axisValue);
                break;
            }
            case 4: {
                this.notifyLeftTriggerMoved(axisValue);
                break;
            }
            case 5: {
                this.notifyRightTriggerMoved(axisValue);
            }
        }
    }

    public void onAccelerometerChanged(GamePad gamePad, int accelerometerCode, Vector3 value) {
    }
}

