/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import java.util.HashMap;
import java.util.Map;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.tiled.Tile;

public class Tileset {
    private Tile[][] tiles;
    private String name;
    private String tilesetImagePath;
    private String transparentColorValue;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int spacing;
    private int margin;
    private int firstGid;
    private int lastGid = Integer.MAX_VALUE;
    private int widthInTiles;
    private int heightInTiles;
    private Map<String, String> properties;

    public Tileset(int width, int height, int tileWidth, int tileHeight, int spacing, int margin, int firstGid) {
        this.width = width;
        this.height = height;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.spacing = spacing;
        this.margin = margin;
        this.firstGid = firstGid;
        this.widthInTiles = -1;
        this.heightInTiles = -1;
        this.calculateLastGid();
        this.tiles = new Tile[this.getWidthInTiles()][this.getHeightInTiles()];
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                this.tiles[x][y] = new Tile();
                this.tiles[x][y].setTileId(this.getTileId(x, y));
            }
        }
    }

    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(propertyName);
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(propertyName, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void drawTile(Graphics g, int tileId, int renderX, int renderY) {
        int tileX = this.getTileX(tileId);
        int tileY = this.getTileY(tileId);
        this.tiles[tileX][tileY].draw(g, renderX, renderY);
    }

    public void drawTileset(Graphics g, int renderX, int renderY) {
        for (int y = 0; y < this.getHeightInTiles(); ++y) {
            for (int x = 0; x < this.getWidthInTiles(); ++x) {
                this.tiles[x][y].draw(g, renderX + x * this.getTileWidth(), renderY + y * this.getTileHeight());
            }
        }
    }

    public Tile getTile(int tileId) {
        int tileX = this.getTileX(tileId);
        int tileY = this.getTileY(tileId);
        return this.tiles[tileX][tileY];
    }

    public Tile getTile(int x, int y) {
        return this.tiles[x][y];
    }

    public boolean isTextureLoaded() {
        return this.tiles[0][0].getTileImage() != null;
    }

    public void loadTexture(FileHandle tmxDirectory) {
        Pixmap pixmap = new Pixmap(tmxDirectory.child(this.tilesetImagePath));
        Texture texture = null;
        if (this.transparentColorValue != null) {
            texture = this.modifyPixmapWithTransparentColor(pixmap);
        } else {
            texture = new Texture(pixmap);
            pixmap.dispose();
        }
        texture.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                int tileX = this.margin + x * this.spacing + x * this.tileWidth;
                int tileY = this.margin + y * this.spacing + y * this.tileHeight;
                TextureRegion tileImage = new TextureRegion(texture, tileX, tileY, this.tileWidth, this.tileHeight);
                this.tiles[x][y].setTileImage(tileImage);
            }
        }
    }

    private Texture modifyPixmapWithTransparentColor(Pixmap pixmap) {
        float r = (float)Integer.parseInt(this.transparentColorValue.substring(0, 2), 16) / 255.0f;
        float g = (float)Integer.parseInt(this.transparentColorValue.substring(2, 4), 16) / 255.0f;
        float b = (float)Integer.parseInt(this.transparentColorValue.substring(4, 6), 16) / 155.0f;
        int transparentColor = Color.rgba8888((Color)new Color(r, g, b, 1.0f));
        Pixmap updatedPixmap = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), Pixmap.Format.RGBA8888);
        for (int x = 0; x < pixmap.getWidth(); ++x) {
            for (int y = 0; y < pixmap.getHeight(); ++y) {
                int pixelColor = pixmap.getPixel(x, y);
                if (pixelColor == transparentColor) continue;
                updatedPixmap.drawPixel(x, y, pixelColor);
            }
        }
        Texture result = new Texture(updatedPixmap);
        updatedPixmap.dispose();
        pixmap.dispose();
        return result;
    }

    private void calculateLastGid() {
        this.lastGid = this.getWidthInTiles() * this.getHeightInTiles() + this.firstGid - 1;
    }

    public boolean contains(int tileId) {
        return tileId >= this.firstGid && tileId <= this.lastGid;
    }

    public int getTileId(int x, int y) {
        return this.firstGid + y * this.getWidthInTiles() + x;
    }

    public int getTileX(int tileId) {
        return (tileId - this.firstGid) % this.getWidthInTiles();
    }

    public int getTileY(int tileId) {
        return (tileId - this.firstGid) / this.getWidthInTiles();
    }

    public int getWidthInTiles() {
        if (this.widthInTiles < 0) {
            int result = 0;
            for (int x = this.margin; x <= this.width - this.tileWidth; x += this.tileWidth + this.spacing) {
                ++result;
            }
            this.widthInTiles = result;
        }
        return this.widthInTiles;
    }

    public int getHeightInTiles() {
        if (this.heightInTiles < 0) {
            int result = 0;
            for (int y = this.margin; y <= this.height - this.tileHeight; y += this.tileHeight + this.spacing) {
                ++result;
            }
            this.heightInTiles = result;
        }
        return this.heightInTiles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public int getMargin() {
        return this.margin;
    }

    public int getFirstGid() {
        return this.firstGid;
    }

    public String getTilesetImagePath() {
        return this.tilesetImagePath;
    }

    public void setTilesetImagePath(String tilesetImagePath) {
        this.tilesetImagePath = tilesetImagePath;
    }

    public String getTransparentColorValue() {
        return this.transparentColorValue;
    }

    public void setTransparentColorValue(String transparentColorValue) {
        this.transparentColorValue = transparentColorValue;
    }
}

