/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.collisions;

import java.util.List;
import org.mini2Dx.core.collisions.QuadTree;
import org.mini2Dx.core.engine.Positionable;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.TiledObject;
import org.mini2Dx.tiled.TiledObjectGroup;
import org.mini2Dx.tiled.collisions.DefaultTiledCollisionMerger;
import org.mini2Dx.tiled.collisions.TiledCollisionFactory;
import org.mini2Dx.tiled.collisions.TiledCollisionMerger;

public class TiledCollisionMapper<T extends Positionable> {
    private final TiledCollisionFactory<T> collisionFactory;
    private final TiledCollisionMerger collisionMerger;

    public TiledCollisionMapper(TiledCollisionFactory<T> collisionFactory) {
        this(collisionFactory, new DefaultTiledCollisionMerger());
    }

    public TiledCollisionMapper(TiledCollisionFactory<T> collisionFactory, TiledCollisionMerger collisionMerger) {
        this.collisionFactory = collisionFactory;
        this.collisionMerger = collisionMerger;
    }

    public static byte[][] mapCollisionsByLayer(TiledMap tiledMap, String layerName) {
        return TiledCollisionMapper.mapCollisionsByLayer(tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public static byte[][] mapCollisionsByLayer(TiledMap tiledMap, int layerIndex) {
        return TiledCollisionMapper.mapCollisionsByLayer(tiledMap, tiledMap.getTileLayer(layerIndex));
    }

    private static byte[][] mapCollisionsByLayer(TiledMap tiledMap, TileLayer layer) {
        byte[][] result = new byte[layer.getWidth()][layer.getHeight()];
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                if (layer.getTileId(x, y) <= 0) continue;
                result[x][y] = 1;
            }
        }
        return result;
    }

    public void mapCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, int layerIndex) {
        if (layerIndex < 0) {
            return;
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                if (layer.getTileId(x, y) <= 0) continue;
                quadTree.add(this.collisionFactory.createCollision(tiledMap.getTile(layer.getTileId(x, y)), x * tiledMap.getTileWidth(), y * tiledMap.getTileHeight(), tiledMap.getTileWidth(), tiledMap.getTileHeight()));
            }
        }
    }

    public void mapCollisionsByLayer(List<T> results, TiledMap tiledMap, int layerIndex) {
        if (layerIndex < 0) {
            return;
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                if (layer.getTileId(x, y) <= 0) continue;
                results.add(this.collisionFactory.createCollision(tiledMap.getTile(layer.getTileId(x, y)), x * tiledMap.getTileWidth(), y * tiledMap.getTileHeight(), tiledMap.getTileWidth(), tiledMap.getTileHeight()));
            }
        }
    }

    public void mapCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, String layerName) {
        this.mapCollisionsByLayer(quadTree, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapCollisionsByLayer(List<T> results, TiledMap tiledMap, String layerName) {
        this.mapCollisionsByLayer(results, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapCollisionsByObjectGroup(QuadTree<T> quadTree, TiledMap tiledMap, String groupName) {
        TiledObjectGroup objectGroup = tiledMap.getObjectGroup(groupName);
        if (objectGroup == null) {
            return;
        }
        for (TiledObject tiledObject : objectGroup.getObjects()) {
            quadTree.add(this.collisionFactory.createCollision(tiledObject));
        }
    }

    public void mapCollisionsByObjectGroup(QuadTree<T> quadTree, TiledMap tiledMap, String groupName, String objectType) {
        TiledObjectGroup objectGroup = tiledMap.getObjectGroup(groupName);
        if (objectGroup == null) {
            return;
        }
        for (TiledObject tiledObject : objectGroup.getObjects()) {
            if (tiledObject.getType() == null || !tiledObject.getType().equalsIgnoreCase(objectType)) continue;
            quadTree.add(this.collisionFactory.createCollision(tiledObject));
        }
    }

    public void mapCollisionsByObjectGroup(List<T> results, TiledMap tiledMap, String groupName) {
        TiledObjectGroup objectGroup = tiledMap.getObjectGroup(groupName);
        if (objectGroup == null) {
            return;
        }
        for (TiledObject tiledObject : objectGroup.getObjects()) {
            results.add(this.collisionFactory.createCollision(tiledObject));
        }
    }

    public void mapCollisionsByObjectGroup(List<T> results, TiledMap tiledMap, String groupName, String objectType) {
        TiledObjectGroup objectGroup = tiledMap.getObjectGroup(groupName);
        if (objectGroup == null) {
            return;
        }
        for (TiledObject tiledObject : objectGroup.getObjects()) {
            if (tiledObject.getType() == null || !tiledObject.getType().equalsIgnoreCase(objectType)) continue;
            results.add(this.collisionFactory.createCollision(tiledObject));
        }
    }

    public void mapAndMergeCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, String layerName) {
        this.mapAndMergeCollisionsByLayer(quadTree, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapAndMergeCollisionsByLayer(QuadTree<T> quadTree, TiledMap tiledMap, int layerIndex) {
        if (layerIndex < 0) {
            return;
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        byte[][] collisions = TiledCollisionMapper.mapCollisionsByLayer(tiledMap, layer);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                if (collisions[x][y] == 0) continue;
                quadTree.add(this.mergeCollisions(x, y, collisions, layer, tiledMap));
            }
        }
    }

    public void mapAndMergeCollisionsByLayer(List<T> results, TiledMap tiledMap, String layerName) {
        this.mapAndMergeCollisionsByLayer(results, tiledMap, tiledMap.getLayerIndex(layerName));
    }

    public void mapAndMergeCollisionsByLayer(List<T> results, TiledMap tiledMap, int layerIndex) {
        if (layerIndex < 0) {
            return;
        }
        TileLayer layer = tiledMap.getTileLayer(layerIndex);
        byte[][] collisions = TiledCollisionMapper.mapCollisionsByLayer(tiledMap, layer);
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                if (collisions[x][y] == 0) continue;
                results.add(this.mergeCollisions(x, y, collisions, layer, tiledMap));
            }
        }
    }

    private T mergeCollisions(int startX, int startY, byte[][] collisions, TileLayer layer, TiledMap tiledMap) {
        Tile startTile = tiledMap.getTile(layer.getTileId(startX, startY));
        Tile nextTile = null;
        int maxXTiles = 0;
        int maxYTiles = 0;
        int y = 1;
        while (y < layer.getHeight() - startY && collisions[startX][startY + y] != 0 && this.collisionMerger.isMergable(startTile, nextTile = tiledMap.getTile(layer.getTileId(startX, startY + y)))) {
            maxYTiles = y++;
        }
        int x = 1;
        while (x < layer.getWidth() - startX) {
            boolean mergeable = true;
            for (int y2 = 0; y2 <= maxYTiles; ++y2) {
                if (collisions[startX + x][startY + y2] == 0) {
                    mergeable = false;
                    break;
                }
                nextTile = tiledMap.getTile(layer.getTileId(startX + x, startY + y2));
                if (this.collisionMerger.isMergable(startTile, nextTile)) continue;
                mergeable = false;
                break;
            }
            if (!mergeable) break;
            maxXTiles = x++;
        }
        for (x = 0; x <= maxXTiles; ++x) {
            for (int y3 = 0; y3 <= maxYTiles; ++y3) {
                collisions[startX + x][startY + y3] = 0;
            }
        }
        return this.collisionFactory.createCollision(startTile, startX * tiledMap.getTileWidth(), startY * tiledMap.getTileHeight(), tiledMap.getTileWidth() + maxXTiles * tiledMap.getTileWidth(), tiledMap.getTileHeight() + maxYTiles * tiledMap.getTileHeight());
    }
}

