/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import com.badlogic.gdx.utils.Disposable;
import java.util.HashMap;
import java.util.Map;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.tiled.renderer.TileRenderer;

public class Tile
implements Disposable {
    private int tileId;
    private TileRenderer tileRenderer;
    private Map<String, String> properties;

    public void update(float delta) {
        if (this.tileRenderer == null) {
            return;
        }
        this.tileRenderer.update(delta);
    }

    public void draw(Graphics g, int renderX, int renderY, boolean flipH, boolean flipV, boolean flipD) {
        if (this.tileRenderer == null) {
            return;
        }
        this.tileRenderer.draw(g, renderX, renderY, flipH, flipV, flipD);
    }

    public void draw(Graphics g, int renderX, int renderY) {
        if (this.tileRenderer == null) {
            return;
        }
        this.tileRenderer.draw(g, renderX, renderY);
    }

    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(propertyName);
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(propertyName, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Deprecated
    public int getTileId() {
        return this.getTileId(0);
    }

    public int getTileId(int firstGid) {
        return firstGid + this.tileId;
    }

    public void setTileId(int tileId) {
        this.tileId = tileId;
    }

    public TileRenderer getTileRenderer() {
        return this.tileRenderer;
    }

    public void setTileRenderer(TileRenderer tileRenderer) {
        this.tileRenderer = tileRenderer;
    }

    public void dispose() {
        if (this.tileRenderer == null) {
            return;
        }
        this.tileRenderer.dispose();
        this.tileRenderer = null;
    }
}

