/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import java.util.BitSet;
import org.mini2Dx.tiled.Layer;
import org.mini2Dx.tiled.LayerType;

public class TileLayer
extends Layer {
    private final int[][] tiles;
    private final BitSet flipHorizontally;
    private final BitSet flipVertically;
    private final BitSet flipDiagonally;

    public TileLayer(int width, int height) {
        super(LayerType.TILE);
        this.tiles = new int[width][height];
        this.flipHorizontally = new BitSet(width * height);
        this.flipVertically = new BitSet(width * height);
        this.flipDiagonally = new BitSet(width * height);
    }

    public int getTileId(int x, int y) {
        return this.tiles[x][y];
    }

    public void setTileId(int x, int y, int id) {
        this.tiles[x][y] = id;
    }

    public void setTileId(int x, int y, int id, boolean flipH, boolean flipV, boolean flipD) {
        this.tiles[x][y] = id;
        this.setFlippedHorizontally(x, y, flipH);
        this.setFlippedVertically(x, y, flipV);
        this.setFlippedDiagonally(x, y, flipD);
    }

    public boolean isFlippedHorizontally(int x, int y) {
        return this.flipHorizontally.get(this.getBitIndex(x, y));
    }

    public void setFlippedHorizontally(int x, int y, boolean flip) {
        this.flipHorizontally.set(this.getBitIndex(x, y), flip);
    }

    public boolean isFlippedVertically(int x, int y) {
        return this.flipVertically.get(this.getBitIndex(x, y));
    }

    public void setFlippedVertically(int x, int y, boolean flip) {
        this.flipVertically.set(this.getBitIndex(x, y), flip);
    }

    public boolean isFlippedDiagonally(int x, int y) {
        return this.flipDiagonally.get(this.getBitIndex(x, y));
    }

    public void setFlippedDiagonally(int x, int y, boolean flip) {
        this.flipDiagonally.set(this.getBitIndex(x, y), flip);
    }

    public int getWidth() {
        return this.tiles.length;
    }

    public int getHeight() {
        return this.tiles[0].length;
    }

    private int getBitIndex(int x, int y) {
        return y * this.tiles.length + x;
    }
}

