/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.tiled.Layer;
import org.mini2Dx.tiled.LayerType;
import org.mini2Dx.tiled.Orientation;
import org.mini2Dx.tiled.StaggerAxis;
import org.mini2Dx.tiled.StaggerIndex;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledObjectGroup;
import org.mini2Dx.tiled.TiledParser;
import org.mini2Dx.tiled.TiledParserListener;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.exception.TiledException;
import org.mini2Dx.tiled.exception.TiledParsingException;
import org.mini2Dx.tiled.exception.UnsupportedOrientationException;
import org.mini2Dx.tiled.renderer.HexagonalTileLayerRenderer;
import org.mini2Dx.tiled.renderer.IsometricTileLayerRenderer;
import org.mini2Dx.tiled.renderer.OrthogonalTileLayerRenderer;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;
import org.mini2Dx.tiled.renderer.TiledObjectGroupRenderer;

public class TiledMap
implements TiledParserListener {
    private String orientationValue;
    private Orientation orientation;
    private StaggerAxis staggerAxis;
    private StaggerIndex staggerIndex;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int pixelWidth;
    private int pixelHeight;
    private int sideLength;
    private Color backgroundColor;
    private List<Tile> animatedTiles;
    protected List<Tileset> tilesets = new ArrayList<Tileset>();
    protected List<Layer> layers = new ArrayList<Layer>();
    protected Map<String, TiledObjectGroup> objectGroups = new HashMap<String, TiledObjectGroup>();
    private Map<String, String> properties;
    private FileHandle fileHandle;
    private TileLayerRenderer tileLayerRenderer;
    private TiledObjectGroupRenderer tiledObjectGroupRenderer;

    public TiledMap() {
    }

    public TiledMap(FileHandle fileHandle) throws TiledException {
        this(fileHandle, true, false);
    }

    public TiledMap(FileHandle fileHandle, boolean loadTilesets, boolean cacheLayers) throws TiledException {
        this(new TiledParser(), fileHandle, loadTilesets, cacheLayers);
    }

    public TiledMap(TiledParser parser, FileHandle fileHandle, boolean loadTilesetTextures, boolean cacheLayers) throws TiledException {
        this();
        this.fileHandle = fileHandle;
        parser.addListener(this);
        try {
            parser.parseTmx(fileHandle);
        }
        catch (IOException e) {
            throw new TiledParsingException(e);
        }
        parser.removeListener(this);
        if (loadTilesetTextures) {
            this.loadTilesetTextures();
        }
        switch (this.orientation) {
            case ORTHOGONAL: {
                this.tileLayerRenderer = new OrthogonalTileLayerRenderer(this, cacheLayers);
                break;
            }
            case ISOMETRIC: {
                this.tileLayerRenderer = new IsometricTileLayerRenderer(this, cacheLayers);
                break;
            }
            case ISOMETRIC_STAGGERED: {
                break;
            }
            case HEXAGONAL: {
                this.tileLayerRenderer = new HexagonalTileLayerRenderer(this, cacheLayers);
                break;
            }
            default: {
                throw new UnsupportedOrientationException(this.orientationValue);
            }
        }
    }

    public boolean isTilesetTexturesLoaded() {
        boolean result = true;
        for (int i = 0; i < this.tilesets.size(); ++i) {
            if (this.tilesets.get(i).isTextureLoaded()) continue;
            return false;
        }
        return result;
    }

    private void loadTilesetTextures() {
        for (int i = 0; i < this.tilesets.size(); ++i) {
            if (this.tilesets.get(i).isTextureLoaded()) continue;
            this.tilesets.get(i).loadTexture(this.fileHandle.parent());
        }
    }

    public void update(float delta) {
        if (this.animatedTiles == null) {
            return;
        }
        for (int i = 0; i < this.animatedTiles.size(); ++i) {
            this.animatedTiles.get(i).update(delta);
        }
    }

    public void draw(Graphics g, int x, int y) {
        this.draw(g, x, y, 0, 0, this.width, this.height);
    }

    public void draw(Graphics g, int x, int y, int layer) {
        this.draw(g, x, y, 0, 0, this.width, this.height, layer);
    }

    public void draw(Graphics g, int x, int y, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.draw(g, x, y, startTileX, startTileY, widthInTiles, heightInTiles, i);
        }
    }

    public void draw(Graphics g, int x, int y, int startTileX, int startTileY, int widthInTiles, int heightInTiles, int layer) {
        Layer tiledLayer = this.layers.get(layer);
        switch (tiledLayer.getLayerType()) {
            case IMAGE: {
                break;
            }
            case OBJECT: {
                this.drawTiledObjectGroup(g, (TiledObjectGroup)tiledLayer, x, y, startTileX, startTileY, widthInTiles, heightInTiles);
                break;
            }
            case TILE: {
                this.drawTileLayer(g, (TileLayer)tiledLayer, x, y, startTileX, startTileY, widthInTiles, heightInTiles);
                break;
            }
        }
    }

    protected boolean preLayerRendered(Graphics g, TileLayer layer, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        return true;
    }

    protected void onLayerRendered(Graphics g, TileLayer layer, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
    }

    private void drawTileLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        if (!this.isTilesetTexturesLoaded()) {
            Gdx.app.error(TiledMap.class.getSimpleName(), "Attempting to render TiledMap without its tilesets loaded");
            return;
        }
        if (!this.preLayerRendered(g, layer, startTileX, startTileY, widthInTiles, heightInTiles)) {
            return;
        }
        this.tileLayerRenderer.drawLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles);
        this.onLayerRendered(g, layer, startTileX, startTileY, widthInTiles, heightInTiles);
    }

    private void drawTiledObjectGroup(Graphics g, TiledObjectGroup objectGroup, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        if (this.tiledObjectGroupRenderer == null) {
            return;
        }
        this.tiledObjectGroupRenderer.drawObjectGroup(g, objectGroup, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles);
    }

    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(propertyName);
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(propertyName, value);
    }

    @Override
    public void onBeginParsing(String orientation, String staggerAxis, String staggerIndex, Color backgroundColor, int width, int height, int tileWidth, int tileHeight, int sideLength) {
        this.orientationValue = orientation;
        try {
            this.orientation = Orientation.valueOf(orientation.toUpperCase());
        }
        catch (Exception e) {
            this.orientation = Orientation.UNKNOWN;
        }
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor;
        }
        if (staggerAxis != null) {
            this.staggerAxis = StaggerAxis.valueOf(staggerAxis.toUpperCase());
            if (sideLength < 0) {
                switch (this.staggerAxis) {
                    case X: {
                        sideLength = tileWidth / 2;
                        break;
                    }
                    default: {
                        sideLength = tileHeight / 2;
                    }
                }
            }
        }
        if (staggerIndex != null) {
            this.staggerIndex = StaggerIndex.valueOf(staggerIndex.toUpperCase());
        }
        this.width = width;
        this.height = height;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.sideLength = sideLength;
        block4 : switch (this.orientation) {
            case HEXAGONAL: {
                switch (this.staggerAxis) {
                    case X: {
                        this.pixelWidth = MathUtils.round((float)((float)tileWidth * 0.75f * (float)width + (float)tileWidth * 0.25f));
                        this.pixelHeight = MathUtils.round((float)((float)(tileHeight * height) + (float)tileHeight * 0.5f));
                        break block4;
                    }
                }
                this.pixelWidth = MathUtils.round((float)((float)(tileWidth * width) + (float)tileWidth * 0.5f));
                this.pixelHeight = MathUtils.round((float)((float)tileHeight * 0.75f * (float)height + (float)tileHeight * 0.25f));
                break;
            }
            case ISOMETRIC_STAGGERED: {
                break;
            }
            default: {
                this.pixelWidth = width * tileWidth;
                this.pixelHeight = height * tileHeight;
            }
        }
    }

    @Override
    public void onMapPropertyParsed(String propertyName, String value) {
        this.setProperty(propertyName, value);
    }

    @Override
    public void onTilePropertiesParsed(Tile tile) {
        if (tile.getTileRenderer() == null) {
            return;
        }
        if (this.animatedTiles == null) {
            this.animatedTiles = new ArrayList<Tile>(1);
        }
        this.animatedTiles.add(tile);
    }

    @Override
    public void onTilesetParsed(Tileset parsedTileset) {
        this.tilesets.add(parsedTileset);
    }

    @Override
    public void onTileLayerParsed(TileLayer parsedLayer) {
        parsedLayer.setIndex(this.layers.size());
        this.layers.add(parsedLayer);
    }

    @Override
    public void onObjectGroupParsed(TiledObjectGroup parsedObjectGroup) {
        parsedObjectGroup.setIndex(this.layers.size());
        this.layers.add(parsedObjectGroup);
        this.objectGroups.put(parsedObjectGroup.getName(), parsedObjectGroup);
    }

    public TileLayer getTileLayer(String name) {
        for (Layer layer : this.layers) {
            if (layer.getName().compareTo(name) != 0 || !layer.getLayerType().equals((Object)LayerType.TILE)) continue;
            return (TileLayer)layer;
        }
        return null;
    }

    public TileLayer getTileLayer(int index) {
        if (index < 0 || index >= this.layers.size()) {
            return null;
        }
        return (TileLayer)this.layers.get(index);
    }

    public TiledObjectGroup getObjectGroup(String name) {
        return this.objectGroups.get(name);
    }

    public Collection<TiledObjectGroup> getObjectGroups() {
        if (this.objectGroups.isEmpty()) {
            return null;
        }
        return this.objectGroups.values();
    }

    public int getLayerIndex(String name) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = this.layers.get(i);
            if (layer.getName().compareTo(name) != 0) continue;
            return i;
        }
        return -1;
    }

    public int getLayerIndexIgnoreCase(String name) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = this.layers.get(i);
            if (layer.getName().compareToIgnoreCase(name) != 0) continue;
            return i;
        }
        return -1;
    }

    public Tile getTile(int tileId) {
        for (int i = 0; i < this.tilesets.size(); ++i) {
            if (!this.tilesets.get(i).contains(tileId)) continue;
            return this.tilesets.get(i).getTile(tileId);
        }
        return null;
    }

    public Tile getTile(int x, int y, int layer) {
        Layer tiledLayer = this.layers.get(layer);
        if (!tiledLayer.getLayerType().equals((Object)LayerType.TILE)) {
            return null;
        }
        return this.getTile(((TileLayer)tiledLayer).getTileId(x, y));
    }

    public void dispose() {
        this.dispose(true);
    }

    public void dispose(boolean disposeTilesets) {
        if (this.tileLayerRenderer != null) {
            this.tileLayerRenderer.dispose();
        }
        if (!disposeTilesets) {
            return;
        }
        for (int i = 0; i < this.tilesets.size(); ++i) {
            this.tilesets.get(i).dispose();
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public StaggerAxis getStaggerAxis() {
        return this.staggerAxis;
    }

    public StaggerIndex getStaggerIndex() {
        return this.staggerIndex;
    }

    public int getSideLength() {
        return this.sideLength;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    public int getPixelHeight() {
        return this.pixelHeight;
    }

    public List<Tileset> getTilesets() {
        return this.tilesets;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public int getTotalObjectGroups() {
        return this.objectGroups.size();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setTileLayerRenderer(TileLayerRenderer tileLayerRenderer) {
        this.tileLayerRenderer = tileLayerRenderer;
    }

    public void setTiledObjectGroupRenderer(TiledObjectGroupRenderer tiledObjectGroupRenderer) {
        this.tiledObjectGroupRenderer = tiledObjectGroupRenderer;
    }

    public boolean containsAnimatedTiles() {
        if (this.animatedTiles == null) {
            return false;
        }
        return !this.animatedTiles.isEmpty();
    }
}

