/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledObject;
import org.mini2Dx.tiled.TiledObjectGroup;
import org.mini2Dx.tiled.TiledParserListener;
import org.mini2Dx.tiled.TiledParserNotifier;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.AnimatedTileRenderer;
import org.mini2Dx.tiled.renderer.StaticTileRenderer;
import org.mini2Dx.tiled.renderer.TileFrame;
import org.mini2Dx.tiled.tileset.ImageTilesetSource;
import org.mini2Dx.tiled.tileset.TilesetSource;
import org.mini2Dx.tiled.tileset.TsxTilesetSource;

public class TiledParser
implements TiledParserNotifier {
    protected static final int FLAG_FLIP_HORIZONTALLY = Integer.MIN_VALUE;
    protected static final int FLAG_FLIP_VERTICALLY = 0x40000000;
    protected static final int FLAG_FLIP_DIAGONALLY = 0x20000000;
    protected static final int MASK_CLEAR = -536870912;
    private XmlReader xmlReader = new XmlReader();
    private List<TiledParserListener> listeners = new ArrayList<TiledParserListener>();

    public void parseTmx(FileHandle tmxFileHandle) throws IOException {
        XmlReader.Element root = this.xmlReader.parse(tmxFileHandle);
        String mapOrientation = root.getAttribute("orientation", null);
        int mapWidth = root.getIntAttribute("width", 0);
        int mapHeight = root.getIntAttribute("height", 0);
        int tileWidth = root.getIntAttribute("tilewidth", 0);
        int tileHeight = root.getIntAttribute("tileheight", 0);
        int sideLength = root.getInt("hexsidelength", -1);
        String staggerAxis = root.getAttribute("staggeraxis", null);
        String staggerIndex = root.getAttribute("staggerindex", null);
        String mapBackgroundColor = root.getAttribute("backgroundcolor", null);
        Color backgroundColor = null;
        if (mapBackgroundColor != null) {
            backgroundColor = this.convertHexColorToColor(mapBackgroundColor);
        }
        this.notifyBeginParsing(mapOrientation, staggerAxis, staggerIndex, backgroundColor, mapWidth, mapHeight, tileWidth, tileHeight, sideLength);
        XmlReader.Element properties = root.getChildByName("properties");
        if (properties != null) {
            this.loadMapProperties(properties);
        }
        Array tilesets = root.getChildrenByName("tileset");
        for (XmlReader.Element element : tilesets) {
            this.loadTileSet(element, tmxFileHandle);
            root.removeChild(element);
        }
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            XmlReader.Element element = root.getChild(i);
            String name = element.getName();
            if (name.equals("layer")) {
                this.loadTileLayer(element);
                continue;
            }
            if (!name.equals("objectgroup")) continue;
            this.loadObjectGroup(element);
        }
    }

    public ImageTilesetSource parseTsx(FileHandle tsxFileHandle) throws IOException {
        XmlReader.Element element = this.xmlReader.parse(tsxFileHandle);
        String name = element.get("name", null);
        int tileWidth = element.getIntAttribute("tilewidth", 0);
        int tileHeight = element.getIntAttribute("tileheight", 0);
        int spacing = element.getIntAttribute("spacing", 0);
        int margin = element.getIntAttribute("margin", 0);
        String imageSource = element.getChildByName("image").getAttribute("source");
        int imageWidth = element.getChildByName("image").getIntAttribute("width", 0);
        int imageHeight = element.getChildByName("image").getIntAttribute("height", 0);
        String transparentColor = element.getChildByName("image").get("trans", null);
        ImageTilesetSource result = new ImageTilesetSource(imageWidth, imageHeight, tileWidth, tileHeight, spacing, margin);
        result.setName(name);
        result.setTilesetImagePath(imageSource);
        result.setTransparentColorValue(transparentColor);
        this.loadTileProperties(result, (Array<XmlReader.Element>)element.getChildrenByName("tile"));
        XmlReader.Element properties = element.getChildByName("properties");
        if (properties != null) {
            for (XmlReader.Element property : properties.getChildrenByName("property")) {
                String propertyName = property.getAttribute("name", null);
                String propertyValue = property.getAttribute("value", null);
                if (propertyValue == null) {
                    propertyValue = property.getText();
                }
                result.setProperty(propertyName, propertyValue);
            }
        }
        return result;
    }

    private void loadMapProperties(XmlReader.Element element) {
        if (element.getName().equals("properties")) {
            for (XmlReader.Element property : element.getChildrenByName("property")) {
                String name = property.getAttribute("name", null);
                String value = property.getAttribute("value", null);
                if (value == null) {
                    value = property.getText();
                }
                this.notifyMapPropertyParsed(name, value);
            }
        }
    }

    private void loadTileSet(XmlReader.Element element, FileHandle tmxFile) {
        if (element.getName().equals("tileset")) {
            Tileset tileset = null;
            String source = element.getAttribute("source", null);
            int firstGid = element.getIntAttribute("firstgid", 1);
            if (source == null) {
                String name = element.get("name", null);
                int tileWidth = element.getIntAttribute("tilewidth", 0);
                int tileHeight = element.getIntAttribute("tileheight", 0);
                int spacing = element.getIntAttribute("spacing", 0);
                int margin = element.getIntAttribute("margin", 0);
                String transparentColor = null;
                String imageSource = "";
                int imageWidth = 0;
                int imageHeight = 0;
                imageSource = element.getChildByName("image").getAttribute("source");
                imageWidth = element.getChildByName("image").getIntAttribute("width", 0);
                imageHeight = element.getChildByName("image").getIntAttribute("height", 0);
                transparentColor = element.getChildByName("image").get("trans", null);
                ImageTilesetSource tilesetSource = new ImageTilesetSource(imageWidth, imageHeight, tileWidth, tileHeight, spacing, margin);
                tilesetSource.setName(name);
                tilesetSource.setTransparentColorValue(transparentColor);
                tilesetSource.setTilesetImagePath(imageSource);
                tileset = new Tileset(firstGid, tilesetSource);
                this.loadTileProperties(tilesetSource, (Array<XmlReader.Element>)element.getChildrenByName("tile"));
                XmlReader.Element properties = element.getChildByName("properties");
                if (properties != null) {
                    for (XmlReader.Element property : properties.getChildrenByName("property")) {
                        String propertyName = property.getAttribute("name", null);
                        String propertyValue = property.getAttribute("value", null);
                        if (propertyValue == null) {
                            propertyValue = property.getText();
                        }
                        tileset.setProperty(propertyName, propertyValue);
                    }
                }
            } else {
                TsxTilesetSource tilesetSource = new TsxTilesetSource(tmxFile.parent(), source);
                tileset = new Tileset(firstGid, tilesetSource);
                for (int x = 0; x < tilesetSource.getWidthInTiles(); ++x) {
                    for (int y = 0; y < tilesetSource.getHeightInTiles(); ++y) {
                        Tile tile = tilesetSource.getTileByPosition(x, y);
                        if (tile == null || tile.getTileRenderer() == null) continue;
                        if (tile.getTileRenderer() instanceof AnimatedTileRenderer) {
                            this.notifyTilePropertyParsed(tile);
                            continue;
                        }
                        if (tile.getProperties() == null) continue;
                        this.notifyTilePropertyParsed(tile);
                    }
                }
            }
            this.notifyTilesetParsed(tileset);
        }
    }

    private void loadTileProperties(TilesetSource tilesetSource, Array<XmlReader.Element> tileElements) {
        for (XmlReader.Element tileElement : tileElements) {
            XmlReader.Element animation;
            XmlReader.Element properties;
            String probability;
            String terrain;
            int localtid = tileElement.getIntAttribute("id", 0);
            Tile tile = tilesetSource.getTile(localtid, 0);
            if (tile == null) continue;
            String type = tileElement.getAttribute("type", null);
            if (type != null) {
                tile.setProperty("type", type);
            }
            if ((terrain = tileElement.getAttribute("terrain", null)) != null) {
                tile.setProperty("terrain", terrain);
            }
            if ((probability = tileElement.getAttribute("probability", null)) != null) {
                tile.setProperty("probability", probability);
            }
            if ((properties = tileElement.getChildByName("properties")) != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String propertyName = property.getAttribute("name", null);
                    String propertyValue = property.getAttribute("value", null);
                    if (propertyValue == null) {
                        propertyValue = property.getText();
                    }
                    tile.setProperty(propertyName, propertyValue);
                }
            }
            if ((animation = tileElement.getChildByName("animation")) != null) {
                Array frameElements = animation.getChildrenByName("frame");
                TileFrame[] frames = new TileFrame[frameElements.size];
                for (int i = 0; i < frameElements.size; ++i) {
                    XmlReader.Element frameElement = (XmlReader.Element)frameElements.get(i);
                    int tileId = frameElement.getIntAttribute("tileid");
                    float duration = frameElement.getFloatAttribute("duration") / 1000.0f;
                    frames[i] = new TileFrame(duration, tileId);
                }
                tile.setTileRenderer(new AnimatedTileRenderer(tilesetSource, frames));
            }
            this.notifyTilePropertyParsed(tile);
        }
        for (int x = 0; x < tilesetSource.getWidthInTiles(); ++x) {
            for (int y = 0; y < tilesetSource.getHeightInTiles(); ++y) {
                Tile tile = tilesetSource.getTileByPosition(x, y);
                if (tile == null || tile.getTileRenderer() != null) continue;
                tile.setTileRenderer(new StaticTileRenderer(tilesetSource, tile));
            }
        }
    }

    protected void loadTileLayer(XmlReader.Element element) {
        if (element.getName().equals("layer")) {
            XmlReader.Element properties;
            String name = element.getAttribute("name", null);
            int width = element.getIntAttribute("width", 0);
            int height = element.getIntAttribute("height", 0);
            boolean visible = element.getIntAttribute("visible", 1) == 1;
            TileLayer layer = new TileLayer(width, height);
            layer.setVisible(visible);
            layer.setName(name);
            XmlReader.Element data = element.getChildByName("data");
            String encoding = data.getAttribute("encoding", null);
            String compression = data.getAttribute("compression", null);
            if (encoding == null) {
                throw new GdxRuntimeException("Unsupported encoding (XML) for TMX Layer Data");
            }
            if (encoding.equals("csv")) {
                String[] array = data.getText().split(",");
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int id = (int)Long.parseLong(array[y * width + x].trim());
                        layer.setTileId(x, y, id &= 0x1FFFFFFF);
                    }
                }
            } else if (encoding.equals("base64")) {
                boolean flipDiagonally;
                boolean flipVertically;
                boolean flipHorizontally;
                int id;
                int x;
                int y;
                byte[] bytes = Base64Coder.decode((String)data.getText());
                if (compression == null) {
                    int read = 0;
                    for (int y2 = 0; y2 < height; ++y2) {
                        for (int x2 = 0; x2 < width; ++x2) {
                            int id2;
                            boolean flipHorizontally2 = ((id2 = TiledParser.unsignedByteToInt(bytes[read++]) | TiledParser.unsignedByteToInt(bytes[read++]) << 8 | TiledParser.unsignedByteToInt(bytes[read++]) << 16 | TiledParser.unsignedByteToInt(bytes[read++]) << 24) & Integer.MIN_VALUE) != 0;
                            boolean flipVertically2 = (id2 & 0x40000000) != 0;
                            boolean flipDiagonally2 = (id2 & 0x20000000) != 0;
                            layer.setTileId(x2, y2, id2 &= 0x1FFFFFFF, flipHorizontally2, flipVertically2, flipDiagonally2);
                        }
                    }
                } else if (compression.equals("gzip")) {
                    GZIPInputStream GZIS = null;
                    try {
                        GZIS = new GZIPInputStream((InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    }
                    catch (IOException e) {
                        throw new GdxRuntimeException("Error Reading TMX Layer Data - IOException: " + e.getMessage());
                    }
                    byte[] temp = new byte[4];
                    for (y = 0; y < height; ++y) {
                        for (x = 0; x < width; ++x) {
                            try {
                                GZIS.read(temp, 0, 4);
                                id = TiledParser.unsignedByteToInt(temp[0]) | TiledParser.unsignedByteToInt(temp[1]) << 8 | TiledParser.unsignedByteToInt(temp[2]) << 16 | TiledParser.unsignedByteToInt(temp[3]) << 24;
                                flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                                flipVertically = (id & 0x40000000) != 0;
                                flipDiagonally = (id & 0x20000000) != 0;
                                layer.setTileId(x, y, id &= 0x1FFFFFFF, flipHorizontally, flipVertically, flipDiagonally);
                                continue;
                            }
                            catch (IOException e) {
                                throw new GdxRuntimeException("Error Reading TMX Layer Data.", (Throwable)e);
                            }
                        }
                    }
                } else if (compression.equals("zlib")) {
                    Inflater zlib = new Inflater();
                    byte[] temp = new byte[4];
                    zlib.setInput(bytes, 0, bytes.length);
                    for (y = 0; y < height; ++y) {
                        for (x = 0; x < width; ++x) {
                            try {
                                zlib.inflate(temp, 0, 4);
                                id = TiledParser.unsignedByteToInt(temp[0]) | TiledParser.unsignedByteToInt(temp[1]) << 8 | TiledParser.unsignedByteToInt(temp[2]) << 16 | TiledParser.unsignedByteToInt(temp[3]) << 24;
                                flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                                flipVertically = (id & 0x40000000) != 0;
                                flipDiagonally = (id & 0x20000000) != 0;
                                layer.setTileId(x, y, id &= 0x1FFFFFFF, flipHorizontally, flipVertically, flipDiagonally);
                                continue;
                            }
                            catch (DataFormatException e) {
                                throw new GdxRuntimeException("Error Reading TMX Layer Data.", (Throwable)e);
                            }
                        }
                    }
                }
            } else {
                throw new GdxRuntimeException("Unrecognised encoding (" + encoding + ") for TMX Layer Data");
            }
            if ((properties = element.getChildByName("properties")) != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String propertyName = property.getAttribute("name", null);
                    String propertyValue = property.getAttribute("value", null);
                    if (propertyValue == null) {
                        propertyValue = property.getText();
                    }
                    layer.setProperty(propertyName, propertyValue);
                }
            }
            this.notifyTileLayerParsed(layer);
        }
    }

    protected void loadObjectGroup(XmlReader.Element element) {
        if (element.getName().equals("objectgroup")) {
            String name = element.getAttribute("name", null);
            TiledObjectGroup tiledObjectGroup = new TiledObjectGroup();
            tiledObjectGroup.setName(name);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String propertyName = property.getAttribute("name", null);
                    String propertyValue = property.getAttribute("value", null);
                    if (propertyValue == null) {
                        propertyValue = property.getText();
                    }
                    tiledObjectGroup.setProperty(propertyName, propertyValue);
                }
            }
            for (XmlReader.Element objectElement : element.getChildrenByName("object")) {
                TiledObject tiledObject = this.loadObject(objectElement);
                if (tiledObject == null) continue;
                tiledObjectGroup.getObjects().add(tiledObject);
            }
            this.notifyObjectGroupParsed(tiledObjectGroup);
        }
    }

    protected TiledObject loadObject(XmlReader.Element element) {
        if (element.getName().equals("object")) {
            int gid;
            float x = element.getFloatAttribute("x", 0.0f);
            float y = element.getFloatAttribute("y", 0.0f);
            float width = element.getFloatAttribute("width", 0.0f);
            float height = element.getFloatAttribute("height", 0.0f);
            TiledObject object = new TiledObject(x, y, width, height);
            object.setName(element.getAttribute("name", null));
            String type = element.getAttribute("type", null);
            if (type != null) {
                object.setType(type);
            }
            if ((gid = element.getIntAttribute("gid", -1)) != -1) {
                object.setGid(gid);
            }
            object.setVisible(element.getIntAttribute("visible", 1) == 1);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String propertyName = property.getAttribute("name", null);
                    String propertyValue = property.getAttribute("value", null);
                    if (propertyValue == null) {
                        propertyValue = property.getText();
                    }
                    object.setProperty(propertyName, propertyValue);
                }
            }
            return object;
        }
        return null;
    }

    static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    @Override
    public void addListener(TiledParserListener tiledParserListener) {
        this.listeners.add(tiledParserListener);
    }

    @Override
    public void removeListener(TiledParserListener tiledParserListener) {
        this.listeners.remove(tiledParserListener);
    }

    @Override
    public void notifyBeginParsing(String orientation, String staggerAxis, String staggerIndex, Color backgroundColor, int width, int height, int tileWidth, int tileHeight, int sideLength) {
        for (TiledParserListener tiledParserListener : this.listeners) {
            tiledParserListener.onBeginParsing(orientation, staggerAxis, staggerIndex, backgroundColor, width, height, tileWidth, tileHeight, sideLength);
        }
    }

    @Override
    public void notifyMapPropertyParsed(String propertyName, String value) {
        for (TiledParserListener tiledParserListener : this.listeners) {
            tiledParserListener.onMapPropertyParsed(propertyName, value);
        }
    }

    @Override
    public void notifyTilePropertyParsed(Tile tile) {
        for (TiledParserListener tiledParserListener : this.listeners) {
            tiledParserListener.onTilePropertiesParsed(tile);
        }
    }

    @Override
    public void notifyTilesetParsed(Tileset parsedTileset) {
        for (TiledParserListener tiledParserListener : this.listeners) {
            tiledParserListener.onTilesetParsed(parsedTileset);
        }
    }

    @Override
    public void notifyTileLayerParsed(TileLayer parsedLayer) {
        for (TiledParserListener tiledParserListener : this.listeners) {
            tiledParserListener.onTileLayerParsed(parsedLayer);
        }
    }

    @Override
    public void notifyObjectGroupParsed(TiledObjectGroup parsedObjectGroup) {
        for (TiledParserListener tiledParserListener : this.listeners) {
            tiledParserListener.onObjectGroupParsed(parsedObjectGroup);
        }
    }

    private Color convertHexColorToColor(String hexColor) {
        return new Color((float)Integer.valueOf(hexColor.substring(1, 3), 16).intValue() / 255.0f, (float)Integer.valueOf(hexColor.substring(3, 5), 16).intValue() / 255.0f, (float)Integer.valueOf(hexColor.substring(5, 7), 16).intValue() / 255.0f, 0.0f);
    }
}

