/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Disposable;
import java.util.Map;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class Tileset
implements Disposable {
    private final TilesetSource tilesetSource;
    private int firstGid;
    private int lastGid = Integer.MAX_VALUE;

    public Tileset(int firstGid, TilesetSource tilesetSource) {
        this.tilesetSource = tilesetSource;
        this.firstGid = firstGid;
        this.calculateLastGid();
    }

    public boolean containsProperty(String propertyName) {
        return this.tilesetSource.containsProperty(propertyName);
    }

    public String getProperty(String propertyName) {
        return this.tilesetSource.getProperty(propertyName);
    }

    public void setProperty(String propertyName, String value) {
        this.tilesetSource.setProperty(propertyName, value);
    }

    public Map<String, String> getProperties() {
        return this.tilesetSource.getProperties();
    }

    public void drawTile(Graphics g, int tileId, int renderX, int renderY) {
        this.tilesetSource.drawTile(g, tileId, this.firstGid, renderX, renderY);
    }

    public void drawTileset(Graphics g, int renderX, int renderY) {
        this.tilesetSource.drawTileset(g, renderX, renderY);
    }

    public Tile getTile(int tileId) {
        return this.tilesetSource.getTile(tileId, this.firstGid);
    }

    public Tile getTile(int x, int y) {
        return this.getTile(this.tilesetSource.getTileId(x, y, this.firstGid));
    }

    public boolean isTextureLoaded() {
        return this.tilesetSource.isTextureLoaded();
    }

    public void loadTexture(FileHandle tmxDirectory) {
        this.tilesetSource.loadTexture(tmxDirectory);
    }

    public void dispose() {
        this.tilesetSource.dispose();
    }

    private void calculateLastGid() {
        this.lastGid = this.getWidthInTiles() * this.getHeightInTiles() + this.firstGid - 1;
    }

    public boolean contains(int tileId) {
        return this.tilesetSource.contains(tileId, this.firstGid, this.lastGid);
    }

    public int getTileId(int x, int y) {
        return this.tilesetSource.getTileId(x, y, this.firstGid);
    }

    public int getTileX(int tileId) {
        return this.tilesetSource.getTileX(tileId, this.firstGid);
    }

    public int getTileY(int tileId) {
        return this.tilesetSource.getTileY(tileId, this.firstGid);
    }

    public int getWidthInTiles() {
        return this.tilesetSource.getWidthInTiles();
    }

    public int getHeightInTiles() {
        return this.tilesetSource.getHeightInTiles();
    }

    public int getWidth() {
        return this.tilesetSource.getWidth();
    }

    public int getHeight() {
        return this.tilesetSource.getHeight();
    }

    public int getTileWidth() {
        return this.tilesetSource.getTileWidth();
    }

    public int getTileHeight() {
        return this.tilesetSource.getTileHeight();
    }

    public int getSpacing() {
        return this.tilesetSource.getSpacing();
    }

    public int getMargin() {
        return this.tilesetSource.getMargin();
    }

    public int getFirstGid() {
        return this.firstGid;
    }
}

