/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import com.badlogic.gdx.Gdx;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.tiled.renderer.TileFrame;
import org.mini2Dx.tiled.renderer.TileRenderer;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class AnimatedTileRenderer
implements TileRenderer {
    private final TileFrame[] frames;
    private final TilesetSource tilesetSource;
    private int currentFrame;
    private float timer;
    private long lastFrameId;

    public AnimatedTileRenderer(TilesetSource tilesetSource, TileFrame[] frames) {
        this.tilesetSource = tilesetSource;
        this.frames = frames;
    }

    @Override
    public void update(float delta) {
        long currentFrameId = Gdx.graphics.getFrameId();
        if (currentFrameId <= this.lastFrameId) {
            return;
        }
        this.timer += delta;
        while (this.timer >= this.frames[this.currentFrame].duration) {
            this.timer -= this.frames[this.currentFrame].duration;
            this.currentFrame = this.currentFrame == this.frames.length - 1 ? 0 : this.currentFrame + 1;
        }
        this.lastFrameId = currentFrameId;
    }

    @Override
    public void draw(Graphics g, int renderX, int renderY) {
        g.drawSprite(this.getCurrentTileImage(), (float)renderX, (float)renderY);
    }

    @Override
    public void draw(Graphics g, int renderX, int renderY, boolean flipH, boolean flipV, boolean flipD) {
        Sprite tileImage = this.getCurrentTileImage();
        boolean previousFlipX = tileImage.isFlipX();
        boolean previousFlipY = tileImage.isFlipY();
        if (flipD) {
            if (flipH && flipV) {
                tileImage.setRotation(90.0f);
                tileImage.setFlip(true, previousFlipY);
            } else if (flipH) {
                tileImage.setRotation(90.0f);
            } else if (flipV) {
                tileImage.setRotation(270.0f);
            } else {
                tileImage.setRotation(90.0f);
                tileImage.setFlip(previousFlipX, true);
            }
        } else {
            tileImage.setFlip(flipH, !flipV);
        }
        g.drawSprite(tileImage, (float)renderX, (float)renderY);
        tileImage.setRotation(0.0f);
        tileImage.setFlip(previousFlipX, previousFlipY);
    }

    @Override
    public Sprite getCurrentTileImage() {
        return this.tilesetSource.getTileImage(this.frames[this.currentFrame].tileId);
    }

    public void dispose() {
    }
}

