/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import com.badlogic.gdx.math.MathUtils;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;

public class HexagonalTileLayerRenderer
implements TileLayerRenderer {
    private final boolean cacheLayers;
    private final TiledMap tiledMap;
    private final int hexWidth;
    private final int hexHeight;
    private final int quarterHexWidth;
    private final int quarterHexHeight;
    private final int halfHexWidth;
    private final int halfHexHeight;
    private final int threeQuarterHexWidth;
    private final int threeQuarterHexHeight;

    public HexagonalTileLayerRenderer(TiledMap tiledMap, boolean cacheLayers) {
        this.cacheLayers = cacheLayers;
        this.tiledMap = tiledMap;
        switch (tiledMap.getStaggerAxis()) {
            case X: {
                this.hexWidth = tiledMap.getSideLength() * 2;
                this.hexHeight = tiledMap.getTileHeight();
                break;
            }
            default: {
                this.hexHeight = tiledMap.getSideLength() * 2;
                this.hexWidth = tiledMap.getTileWidth();
            }
        }
        this.quarterHexWidth = MathUtils.round((float)((float)this.hexWidth * 0.25f));
        this.quarterHexHeight = MathUtils.round((float)((float)this.hexHeight * 0.25f));
        this.halfHexWidth = MathUtils.round((float)((float)this.hexWidth * 0.5f));
        this.halfHexHeight = MathUtils.round((float)((float)this.hexHeight * 0.5f));
        this.threeQuarterHexWidth = MathUtils.round((float)((float)this.hexWidth * 0.75f));
        this.threeQuarterHexHeight = MathUtils.round((float)((float)this.hexHeight * 0.75f));
    }

    @Override
    public void drawLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        switch (this.tiledMap.getStaggerAxis()) {
            case X: {
                this.drawStaggeredXLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles);
                break;
            }
            default: {
                this.drawStaggeredYLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles);
            }
        }
    }

    private void drawStaggeredXLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        block3: for (int y = 0; y < heightInTiles; ++y) {
            switch (this.tiledMap.getStaggerIndex()) {
                case EVEN: {
                    int tileRenderY;
                    int tileRenderX;
                    int tileId;
                    int x;
                    int row1Offset = startTileX % 2 == 0 ? 1 : 0;
                    int row2Offset = startTileX % 2 == 0 ? 0 : 1;
                    for (x = row1Offset; x < widthInTiles; x += 2) {
                        tileId = layer.getTileId(x + startTileX, y + startTileY);
                        if (tileId < 1) continue;
                        tileRenderX = renderX + x * this.threeQuarterHexWidth;
                        tileRenderY = renderY + y * this.hexHeight;
                        this.renderTile(g, tileId, tileRenderX, tileRenderY);
                    }
                    for (x = row2Offset; x < widthInTiles; x += 2) {
                        tileId = layer.getTileId(x + startTileX, y + startTileY);
                        if (tileId < 1) continue;
                        tileRenderX = renderX + x * this.threeQuarterHexWidth;
                        tileRenderY = renderY + y * this.hexHeight + this.halfHexHeight;
                        this.renderTile(g, tileId, tileRenderX, tileRenderY);
                    }
                    continue block3;
                }
                default: {
                    int tileRenderY;
                    int tileRenderX;
                    int tileId;
                    int x;
                    int row1Offset = startTileX % 2 == 0 ? 0 : 1;
                    int row2Offset = startTileX % 2 == 0 ? 1 : 0;
                    for (x = row1Offset; x < widthInTiles; x += 2) {
                        tileId = layer.getTileId(x + startTileX, y + startTileY);
                        if (tileId < 1) continue;
                        tileRenderX = renderX + x * this.threeQuarterHexWidth;
                        tileRenderY = renderY + y * this.hexHeight;
                        this.renderTile(g, tileId, tileRenderX, tileRenderY);
                    }
                    for (x = row2Offset; x < widthInTiles; x += 2) {
                        tileId = layer.getTileId(x + startTileX, y + startTileY);
                        if (tileId < 1) continue;
                        tileRenderX = renderX + x * this.threeQuarterHexWidth;
                        tileRenderY = renderY + y * this.hexHeight + this.halfHexHeight;
                        this.renderTile(g, tileId, tileRenderX, tileRenderY);
                    }
                }
            }
        }
    }

    private void drawStaggeredYLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        for (int y = 0; y < heightInTiles; ++y) {
            int tileRenderY = renderY + y * this.threeQuarterHexHeight;
            for (int x = 0; x < widthInTiles; ++x) {
                int tileId = layer.getTileId(x + startTileX, y + startTileY);
                if (tileId < 1) continue;
                int tileRenderX = renderX + x * this.hexWidth;
                switch (this.tiledMap.getStaggerIndex()) {
                    case EVEN: {
                        if (y % 2 != 0) break;
                        tileRenderX += this.halfHexWidth;
                        break;
                    }
                    default: {
                        if (y % 2 != 1) break;
                        tileRenderX += this.halfHexWidth;
                    }
                }
                this.renderTile(g, tileId, tileRenderX, tileRenderY);
            }
        }
    }

    private void renderTile(Graphics g, int tileId, int tileRenderX, int tileRenderY) {
        for (int i = 0; i < this.tiledMap.getTilesets().size(); ++i) {
            Tileset tileset = this.tiledMap.getTilesets().get(i);
            if (!tileset.contains(tileId)) continue;
            tileset.getTile(tileId).draw(g, tileRenderX, tileRenderY);
            break;
        }
    }

    @Override
    public void dispose() {
    }
}

