/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import com.badlogic.gdx.math.MathUtils;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;
import org.mini2Dx.tiled.renderer.TiledMapRenderArea;

public class IsometricTileLayerRenderer
implements TileLayerRenderer {
    private TiledMapRenderArea mapClip;
    private TiledMapRenderArea tmpClip;
    private final boolean cacheLayers;
    private final TiledMap tiledMap;
    private final float halfTileWidth;
    private final float halfTileHeight;

    public IsometricTileLayerRenderer(TiledMap tiledMap, boolean cacheLayers) {
        this.cacheLayers = cacheLayers;
        this.tiledMap = tiledMap;
        this.halfTileWidth = (float)tiledMap.getTileWidth() / 2.0f;
        this.halfTileHeight = (float)tiledMap.getTileHeight() / 2.0f;
    }

    @Override
    public void drawLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        this.renderLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles);
    }

    private void renderLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        int totalRows = widthInTiles + heightInTiles;
        for (int row = 0; row < totalRows - 1; ++row) {
            int startX = this.getStartX(row, heightInTiles);
            int endY = this.getEndY(row, widthInTiles);
            int totalCols = this.getTotalCols(row, widthInTiles, heightInTiles);
            block1: for (int col = 0; col < totalCols; ++col) {
                int relativeTileX = col + startX;
                int relativeTileY = totalCols - col - 1 + endY;
                int tileId = layer.getTileId(startTileX + relativeTileX, startTileY + relativeTileY);
                if (tileId < 1) continue;
                int tileRenderX = MathUtils.round((float)((float)renderX + (float)(relativeTileX - relativeTileY) * this.halfTileWidth));
                int tileRenderY = MathUtils.round((float)((float)renderY + (float)(relativeTileX + relativeTileY) * this.halfTileHeight));
                for (int i = 0; i < this.tiledMap.getTilesets().size(); ++i) {
                    Tileset tileset = this.tiledMap.getTilesets().get(i);
                    if (!tileset.contains(tileId)) continue;
                    tileset.getTile(tileId).draw(g, tileRenderX, tileRenderY);
                    continue block1;
                }
            }
        }
    }

    private int getTotalCols(int row, int width, int height) {
        if (row < width && row < height) {
            return row + 1;
        }
        if (row >= height) {
            return width + height - row - 1;
        }
        return Math.min(width, height);
    }

    private int getStartX(int row, int height) {
        if (row < height) {
            return 0;
        }
        return row - height + 1;
    }

    private int getEndY(int row, int width) {
        if (row < width) {
            return 0;
        }
        return row - width + 1;
    }

    @Override
    public void dispose() {
    }
}

