/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import com.badlogic.gdx.graphics.g2d.SpriteCache;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import java.util.HashMap;
import java.util.Map;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;
import org.mini2Dx.tiled.renderer.TiledMapRenderArea;

public class OrthogonalTileLayerRenderer
implements TileLayerRenderer {
    private TiledMapRenderArea mapClip;
    private TiledMapRenderArea tmpClip;
    private SpriteCache layerCache;
    private Map<Integer, Integer> layerCacheIds;
    private final boolean cacheLayers;
    private final TiledMap tiledMap;

    public OrthogonalTileLayerRenderer(TiledMap tiledMap, boolean cacheLayers) {
        this.cacheLayers = cacheLayers;
        this.tiledMap = tiledMap;
        if (cacheLayers) {
            this.layerCache = new SpriteCache(5000, true);
            this.layerCacheIds = new HashMap<Integer, Integer>();
        }
        this.mapClip = new TiledMapRenderArea();
        this.tmpClip = new TiledMapRenderArea();
    }

    @Override
    public void drawLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        int startTileRenderX = startTileX * this.tiledMap.getTileWidth();
        int startTileRenderY = startTileY * this.tiledMap.getTileHeight();
        int tileRenderX = MathUtils.round((float)(renderX - startTileRenderX));
        int tileRenderY = MathUtils.round((float)(renderY - startTileRenderY));
        Rectangle existingClip = g.removeClip();
        Rectangle newClip = new Rectangle((float)startTileRenderX, (float)startTileRenderY, (float)(widthInTiles * this.tiledMap.getTileWidth()), (float)(heightInTiles * this.tiledMap.getTileHeight()));
        g.translate((float)(-tileRenderX), (float)(-tileRenderY));
        if (existingClip != null) {
            if (existingClip.intersects(newClip)) {
                g.setClip(existingClip.intersection(newClip));
            } else {
                g.setClip(existingClip);
            }
        } else {
            g.setClip(newClip);
        }
        if (this.cacheLayers) {
            this.renderCachedLayer(g, layer, tileRenderX, tileRenderY, startTileX, startTileY, widthInTiles, heightInTiles);
        } else {
            this.renderLayer(g, layer, tileRenderX, tileRenderY, startTileX, startTileY, widthInTiles, heightInTiles);
        }
        g.removeClip();
        g.translate((float)tileRenderX, (float)tileRenderY);
        if (existingClip != null) {
            g.setClip(existingClip.getX(), existingClip.getY(), existingClip.getWidth(), existingClip.getHeight());
        }
    }

    private void renderCachedLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        this.tmpClip.set(startTileX, startTileY, widthInTiles, heightInTiles);
        if (!this.mapClip.equals(this.tmpClip)) {
            this.layerCache.clear();
            this.mapClip.set(startTileX, startTileY, widthInTiles, heightInTiles);
        }
        if (!this.layerCacheIds.containsKey(layer)) {
            this.renderLayerToCache(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles);
        }
        int cacheId = this.layerCacheIds.get(layer.getIndex());
        g.drawSpriteCache(this.layerCache, cacheId);
    }

    private void renderLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        for (int y = startTileY; y < startTileY + heightInTiles && y < layer.getHeight(); ++y) {
            block1: for (int x = startTileX; x < startTileX + widthInTiles && x < layer.getWidth(); ++x) {
                int tileId = layer.getTileId(x, y);
                if (tileId < 1) continue;
                boolean flipHorizontally = layer.isFlippedHorizontally(x, y);
                boolean flipVertically = layer.isFlippedVertically(x, y);
                boolean flipDiagonally = layer.isFlippedDiagonally(x, y);
                int tileRenderX = x * this.tiledMap.getTileWidth();
                int tileRenderY = y * this.tiledMap.getTileHeight();
                if ((float)(tileRenderX + this.tiledMap.getTileWidth()) < g.getTranslationX() || (float)(tileRenderY + this.tiledMap.getTileHeight()) < g.getTranslationY() || (float)tileRenderX > g.getTranslationX() + g.getViewportWidth() || (float)tileRenderY > g.getTranslationY() + g.getViewportHeight()) continue;
                for (int i = 0; i < this.tiledMap.getTilesets().size(); ++i) {
                    Tileset tileset = this.tiledMap.getTilesets().get(i);
                    if (!tileset.contains(tileId)) continue;
                    tileset.getTile(tileId).draw(g, tileRenderX, tileRenderY, flipHorizontally, flipVertically, flipDiagonally);
                    continue block1;
                }
            }
        }
    }

    private void renderLayerToCache(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles) {
        this.layerCache.beginCache();
        for (int y = startTileY; y < startTileY + heightInTiles && y < layer.getHeight(); ++y) {
            block1: for (int x = startTileX; x < startTileX + widthInTiles && x < layer.getWidth(); ++x) {
                int tileId = layer.getTileId(x, y);
                if (tileId < 1) continue;
                boolean flipHorizontally = layer.isFlippedHorizontally(x, y);
                boolean flipVertically = layer.isFlippedVertically(x, y);
                boolean flipDiagonally = layer.isFlippedDiagonally(x, y);
                int tileRenderX = x * this.tiledMap.getTileWidth();
                int tileRenderY = y * this.tiledMap.getTileHeight();
                for (int i = 0; i < this.tiledMap.getTilesets().size(); ++i) {
                    Tileset tileset = this.tiledMap.getTilesets().get(i);
                    if (!tileset.contains(tileId)) continue;
                    this.layerCache.add((TextureRegion)tileset.getTile(tileId).getTileRenderer().getCurrentTileImage(), (float)tileRenderX, (float)tileRenderY);
                    continue block1;
                }
            }
        }
        this.layerCacheIds.put(layer.getIndex(), this.layerCache.endCache());
    }

    @Override
    public void dispose() {
        if (this.layerCache == null) {
            return;
        }
        this.layerCache.dispose();
    }
}

