/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.renderer.TileRenderer;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class StaticTileRenderer
implements TileRenderer {
    private final Tile tile;
    private final TilesetSource tilesetSource;

    public StaticTileRenderer(TilesetSource tilesetSource, Tile tile) {
        this.tilesetSource = tilesetSource;
        this.tile = tile;
    }

    @Override
    public void update(float delta) {
    }

    @Override
    public void draw(Graphics g, int renderX, int renderY) {
        g.drawSprite(this.getCurrentTileImage(), (float)renderX, (float)renderY);
    }

    @Override
    public void draw(Graphics g, int renderX, int renderY, boolean flipH, boolean flipV, boolean flipD) {
        Sprite tileImage = this.getCurrentTileImage();
        boolean previousFlipX = tileImage.isFlipX();
        boolean previousFlipY = tileImage.isFlipY();
        if (flipD) {
            if (flipH && flipV) {
                tileImage.setRotation(90.0f);
                tileImage.setFlip(true, previousFlipY);
            } else if (flipH) {
                tileImage.setRotation(90.0f);
            } else if (flipV) {
                tileImage.setRotation(270.0f);
            } else {
                tileImage.setRotation(90.0f);
                tileImage.setFlip(previousFlipX, false);
            }
        } else {
            tileImage.setFlip(flipH, !flipV);
        }
        g.drawSprite(tileImage, (float)renderX, (float)renderY);
        tileImage.setRotation(0.0f);
        tileImage.setFlip(previousFlipX, previousFlipY);
    }

    @Override
    public Sprite getCurrentTileImage() {
        return this.tilesetSource.getTileImage(this.tile.getTileId(0));
    }

    public void dispose() {
    }
}

