/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.tileset;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import java.util.HashMap;
import java.util.Map;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class ImageTilesetSource
extends TilesetSource {
    private final Tile[][] tiles;
    private final Map<Integer, Sprite> tileImages = new HashMap<Integer, Sprite>();
    private final int width;
    private final int height;
    private final int tileWidth;
    private final int tileHeight;
    private final int spacing;
    private final int margin;
    private String name;
    private String tilesetImagePath;
    private String transparentColorValue;
    private Map<String, String> properties;
    private int widthInTiles;
    private int heightInTiles;
    private Texture texture;

    public ImageTilesetSource(int width, int height, int tileWidth, int tileHeight, int spacing, int margin) {
        this.width = width;
        this.height = height;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.spacing = spacing;
        this.margin = margin;
        this.widthInTiles = -1;
        this.heightInTiles = -1;
        this.tiles = new Tile[this.getWidthInTiles()][this.getHeightInTiles()];
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                this.tiles[x][y] = new Tile();
                this.tiles[x][y].setTileId(this.getTileId(x, y, 0));
            }
        }
    }

    private Texture modifyPixmapWithTransparentColor(Pixmap pixmap) {
        float r = (float)Integer.parseInt(this.transparentColorValue.substring(0, 2), 16) / 255.0f;
        float g = (float)Integer.parseInt(this.transparentColorValue.substring(2, 4), 16) / 255.0f;
        float b = (float)Integer.parseInt(this.transparentColorValue.substring(4, 6), 16) / 155.0f;
        int transparentColor = Color.rgba8888((Color)new Color(r, g, b, 1.0f));
        Pixmap updatedPixmap = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), Pixmap.Format.RGBA8888);
        for (int x = 0; x < pixmap.getWidth(); ++x) {
            for (int y = 0; y < pixmap.getHeight(); ++y) {
                int pixelColor = pixmap.getPixel(x, y);
                if (pixelColor == transparentColor) continue;
                updatedPixmap.drawPixel(x, y, pixelColor);
            }
        }
        Texture result = new Texture(updatedPixmap);
        updatedPixmap.dispose();
        pixmap.dispose();
        return result;
    }

    @Override
    public void loadTexture(FileHandle tmxDirectory) {
        if (this.texture != null) {
            return;
        }
        Pixmap pixmap = new Pixmap(tmxDirectory.child(this.tilesetImagePath));
        if (this.transparentColorValue != null) {
            this.texture = this.modifyPixmapWithTransparentColor(pixmap);
        } else {
            this.texture = new Texture(pixmap);
            pixmap.dispose();
        }
        this.texture.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                int tileX = this.margin + x * this.spacing + x * this.tileWidth;
                int tileY = this.margin + y * this.spacing + y * this.tileHeight;
                Sprite tileImage = new Sprite(this.texture, tileX, tileY, this.tileWidth, this.tileHeight);
                this.tileImages.put(this.tiles[x][y].getTileId(0), tileImage);
            }
        }
    }

    @Override
    public boolean isTextureLoaded() {
        return this.texture != null;
    }

    @Override
    public Sprite getTileImage(int tileId) {
        return this.tileImages.get(tileId);
    }

    @Override
    public int getWidthInTiles() {
        if (this.widthInTiles < 0) {
            int result = 0;
            for (int x = this.margin; x <= this.width - this.tileWidth; x += this.tileWidth + this.spacing) {
                ++result;
            }
            this.widthInTiles = result;
        }
        return this.widthInTiles;
    }

    @Override
    public int getHeightInTiles() {
        if (this.heightInTiles < 0) {
            int result = 0;
            for (int y = this.margin; y <= this.height - this.tileHeight; y += this.tileHeight + this.spacing) {
                ++result;
            }
            this.heightInTiles = result;
        }
        return this.heightInTiles;
    }

    @Override
    public Tile getTileByPosition(int x, int y) {
        return this.tiles[x][y];
    }

    @Override
    public Tile getTile(int tileId, int firstGid) {
        int tileX = this.getTileX(tileId, firstGid);
        int tileY = this.getTileY(tileId, firstGid);
        return this.tiles[tileX][tileY];
    }

    @Override
    public void drawTile(Graphics g, int tileId, int firstGid, int renderX, int renderY) {
        int tileX = this.getTileX(tileId, firstGid);
        int tileY = this.getTileY(tileId, firstGid);
        this.tiles[tileX][tileY].draw(g, renderX, renderY);
    }

    @Override
    public void drawTileset(Graphics g, int renderX, int renderY) {
        for (int y = 0; y < this.getHeightInTiles(); ++y) {
            for (int x = 0; x < this.getWidthInTiles(); ++x) {
                this.tiles[x][y].draw(g, renderX + x * this.getTileWidth(), renderY + y * this.getTileHeight());
            }
        }
    }

    @Override
    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(propertyName);
    }

    @Override
    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propertyName);
    }

    @Override
    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(propertyName, value);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public int getMargin() {
        return this.margin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTilesetImagePath() {
        return this.tilesetImagePath;
    }

    public void setTilesetImagePath(String tilesetImagePath) {
        this.tilesetImagePath = tilesetImagePath;
    }

    public String getTransparentColorValue() {
        return this.transparentColorValue;
    }

    public void setTransparentColorValue(String transparentColorValue) {
        this.transparentColorValue = transparentColorValue;
    }

    public void dispose() {
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                if (this.tiles[x][y] == null) continue;
                this.tiles[x][y].dispose();
            }
        }
        this.texture.dispose();
        this.texture = null;
    }
}

