/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.tileset;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TiledParser;
import org.mini2Dx.tiled.tileset.ImageTilesetSource;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class TsxTilesetSource
extends TilesetSource {
    private static final String LOGGING_TAG = TsxTilesetSource.class.getSimpleName();
    private static final TiledParser TSX_PARSER = new TiledParser();
    private static final Map<String, ImageTilesetSource> TILESETS = new ConcurrentHashMap<String, ImageTilesetSource>();
    private static final Map<String, AtomicInteger> TILESET_REFS = new HashMap<String, AtomicInteger>();
    private final String tsxPath;
    private final ImageTilesetSource tileset;

    public TsxTilesetSource(FileHandle tmxDirectory, String tsxPath) {
        this.tsxPath = tsxPath;
        if (!TILESETS.containsKey(tsxPath)) {
            try {
                TILESETS.put(tsxPath, TSX_PARSER.parseTsx(tmxDirectory.child(tsxPath)));
            }
            catch (IOException e) {
                Gdx.app.error(LOGGING_TAG, "Could not parse " + tsxPath + ". " + e.getMessage(), (Throwable)e);
                TILESETS.put(tsxPath, null);
            }
            TILESET_REFS.put(tsxPath, new AtomicInteger(0));
        }
        this.tileset = TILESETS.get(tsxPath);
        TILESET_REFS.get(tsxPath).incrementAndGet();
    }

    @Override
    public void loadTexture(FileHandle tmxDirectory) {
        this.tileset.loadTexture(tmxDirectory);
    }

    @Override
    public boolean isTextureLoaded() {
        return this.tileset.isTextureLoaded();
    }

    @Override
    public Sprite getTileImage(int tileId) {
        return this.tileset.getTileImage(tileId);
    }

    @Override
    public int getWidthInTiles() {
        return this.tileset.getWidthInTiles();
    }

    @Override
    public int getHeightInTiles() {
        return this.tileset.getHeightInTiles();
    }

    @Override
    public void drawTile(Graphics g, int tileId, int firstGid, int renderX, int renderY) {
        this.tileset.drawTile(g, tileId, firstGid, renderX, renderY);
    }

    @Override
    public void drawTileset(Graphics g, int renderX, int renderY) {
        this.tileset.drawTileset(g, renderX, renderY);
    }

    @Override
    public int getWidth() {
        return this.tileset.getWidth();
    }

    @Override
    public int getHeight() {
        return this.tileset.getHeight();
    }

    @Override
    public int getTileWidth() {
        return this.tileset.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.tileset.getTileHeight();
    }

    @Override
    public int getSpacing() {
        return this.tileset.getSpacing();
    }

    @Override
    public int getMargin() {
        return this.tileset.getMargin();
    }

    @Override
    public Tile getTileByPosition(int x, int y) {
        return this.tileset.getTileByPosition(x, y);
    }

    @Override
    public Tile getTile(int tileId, int firstGid) {
        return this.tileset.getTile(tileId, firstGid);
    }

    @Override
    public boolean containsProperty(String propertyName) {
        return this.tileset.containsProperty(propertyName);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.tileset.getProperty(propertyName);
    }

    @Override
    public void setProperty(String propertyName, String value) {
        this.tileset.setProperty(propertyName, value);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.tileset.getProperties();
    }

    public String getTsxPath() {
        return this.tsxPath;
    }

    public void dispose() {
        int remainingRefs = TILESET_REFS.get(this.tsxPath).decrementAndGet();
        if (remainingRefs > 0) {
            return;
        }
        ImageTilesetSource tilesetSource = TILESETS.remove(this.tsxPath);
        if (tilesetSource == null) {
            return;
        }
        tilesetSource.dispose();
    }
}

