/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.BaseEntitySystem;
import com.artemis.BaseSystem;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.WildBag;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ReflectionUtil;
import java.util.Arrays;
import org.mini2Dx.gdx.math.MathUtils;

public abstract class DispersedIntervalEntitySystem
extends BaseEntitySystem
implements EntitySubscription.SubscriptionListener {
    static final int FLAG_INSERTED = 1;
    static final int FLAG_REMOVED = 2;
    protected final IntBag processingQueue = new IntBag();
    private float interval;
    private float timer;
    private float updateDelta;
    protected int entitiesPerUpdate;
    private boolean shouldSyncEntities;
    private WildBag<Entity> entities = new WildBag(Entity.class);
    private int methodFlags;

    public DispersedIntervalEntitySystem(Aspect.Builder aspect, float interval) {
        super(aspect);
        this.interval = interval;
        this.timer = interval;
    }

    protected abstract void update(int var1, float var2);

    protected void processSystem() {
        this.updateDelta += this.getWorld().getDelta();
        for (int i = 0; i < this.entitiesPerUpdate && this.processingQueue.size() > 0; ++i) {
            int nextEntityId = this.processingQueue.remove(0);
            this.update(nextEntityId, this.updateDelta);
        }
        this.timer += this.getWorld().getDelta();
        if (this.timer >= this.interval) {
            this.updateDelta = this.timer;
            this.timer %= this.interval;
            int totalEntities = this.getEntityIds().size();
            this.entitiesPerUpdate = MathUtils.round((float)((float)(totalEntities + this.processingQueue.size()) / this.interval));
            this.entitiesPerUpdate = Math.max(1, this.entitiesPerUpdate);
            for (int i = 0; i < totalEntities; ++i) {
                this.processingQueue.add(this.getEntityIds().get(i));
            }
        }
    }

    protected void setWorld(World world) {
        super.setWorld(world);
        if (ReflectionUtil.implementsObserver((BaseSystem)this, (String)"inserted")) {
            this.methodFlags |= 1;
        }
        if (ReflectionUtil.implementsObserver((BaseSystem)this, (String)"removed")) {
            this.methodFlags |= 2;
        }
    }

    public final void inserted(IntBag entities) {
        this.shouldSyncEntities = true;
        if ((this.methodFlags & 1) > 0) {
            super.inserted(entities);
        }
    }

    protected final void inserted(int entityId) {
    }

    public final void removed(IntBag entities) {
        this.shouldSyncEntities = true;
        if ((this.methodFlags & 2) > 0) {
            super.removed(entities);
        }
    }

    protected final void removed(int entityId) {
        this.processingQueue.removeValue(entityId);
    }

    public void inserted(Entity e) {
        throw new RuntimeException("everything changes");
    }

    public void removed(Entity e) {
        throw new RuntimeException("everything breaks");
    }

    public Bag<Entity> getEntities() {
        if (this.shouldSyncEntities) {
            int oldSize = this.entities.size();
            this.entities.setSize(0);
            IntBag entityIds = this.subscription.getEntities();
            int[] ids = entityIds.getData();
            for (int i = 0; i < entityIds.size(); ++i) {
                this.entities.add((Object)this.world.getEntity(ids[i]));
            }
            if (oldSize > this.entities.size()) {
                Arrays.fill(this.entities.getData(), this.entities.size(), oldSize, null);
            }
            this.shouldSyncEntities = false;
        }
        return this.entities;
    }

    public float getInterval() {
        return this.interval;
    }

    public void setInterval(float interval) {
        this.interval = interval;
    }
}

