/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.BaseSystem;
import com.artemis.Entity;
import com.artemis.MdxInvocationStrategy;
import com.artemis.RenderingSystem;
import com.artemis.SystemInvocationStrategy;
import com.artemis.World;
import com.artemis.WorldConfiguration;
import com.artemis.listener.WorldListener;
import com.artemis.utils.Bag;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.gdx.utils.Array;

public class MdxWorld
extends World {
    private final Bag<RenderingSystem> renderingSystemsBag = new Bag();
    private final MdxInvocationStrategy mdxInvocationStrategy = new MdxInvocationStrategy();
    private Array<WorldListener> worldListeners;
    public float alpha;

    public MdxWorld(WorldConfiguration configuration) {
        super(configuration);
        for (BaseSystem system : configuration.systems) {
            if (!(system instanceof RenderingSystem)) continue;
            this.renderingSystemsBag.add((Object)((RenderingSystem)system));
        }
        this.setInvocationStrategy((SystemInvocationStrategy)this.mdxInvocationStrategy);
    }

    public void render(Graphics g) {
        this.mdxInvocationStrategy.render(this.renderingSystemsBag, g);
    }

    public int create() {
        int result = super.create();
        this.notifyWorldListenersOnCreate(result);
        return result;
    }

    public Entity createEntity() {
        Entity result = super.createEntity();
        this.notifyWorldListenersOnCreate(result.id);
        return result;
    }

    public void deleteEntity(Entity e) {
        this.notifyWorldListenersOnDeleted(e.id);
        super.deleteEntity(e);
    }

    public void delete(int entityId) {
        this.notifyWorldListenersOnDeleted(entityId);
        super.delete(entityId);
    }

    private void notifyWorldListenersOnCreate(int entityId) {
        if (this.worldListeners == null) {
            return;
        }
        for (int i = this.worldListeners.size - 1; i >= 0; --i) {
            ((WorldListener)this.worldListeners.get(i)).afterEntityCreated(this, entityId);
        }
    }

    private void notifyWorldListenersOnDeleted(int entityId) {
        if (this.worldListeners == null) {
            return;
        }
        for (int i = this.worldListeners.size - 1; i >= 0; --i) {
            ((WorldListener)this.worldListeners.get(i)).beforeEntityDeleted(this, entityId);
        }
    }

    public void addWorldListener(WorldListener listener) {
        if (this.worldListeners == null) {
            this.worldListeners = new Array();
        }
        this.worldListeners.add((Object)listener);
    }

    public void removeWorldListener(WorldListener listener) {
        if (this.worldListeners == null) {
            return;
        }
        this.worldListeners.removeValue((Object)listener, false);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

