/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.EntitySystem;
import com.artemis.MdxWorld;
import com.artemis.RenderingSystem;
import com.artemis.World;
import com.artemis.utils.IntBag;
import org.mini2Dx.core.Graphics;

public abstract class RenderingEntitySystem
extends EntitySystem
implements RenderingSystem {
    private MdxWorld mdxWorld;
    private IntBag activeEntityBag;
    private int[] activeEntityIds;

    public RenderingEntitySystem(Aspect.Builder aspect) {
        super(aspect);
    }

    protected void preRender(Graphics g) {
    }

    protected abstract void render(int var1, Graphics var2);

    protected void postRender(Graphics g) {
    }

    protected void processSystem() {
    }

    @Override
    public void renderSystem(Graphics g) {
        if (this.mdxWorld == null) {
            return;
        }
        this.activeEntityBag = this.subscription.getEntities();
        if (this.activeEntityBag == null) {
            return;
        }
        this.activeEntityIds = this.activeEntityBag.getData();
        this.preRender(g);
        int s = this.activeEntityBag.size();
        for (int i = 0; s > i; ++i) {
            this.render(this.activeEntityIds[i], g);
        }
        this.postRender(g);
    }

    public void setWorld(World world) {
        super.setWorld(world);
        if (world instanceof MdxWorld) {
            this.mdxWorld = (MdxWorld)world;
        }
    }
}

