/*******************************************************************************
 * Copyright 2019 Viridian Software Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.mini2Dx.core.collision;

import org.mini2Dx.core.geom.Positionable;

class QuadTreeAwareUtils {
    private QuadTreeAwareUtils(){
        //this class can't be instantiated
    }

    static <T extends Positionable> void setQuadTreeRef(T ref, QuadTree<T> quadTree){
        if (ref instanceof QuadTreeAware){
            ((QuadTreeAware) ref).setQuad(quadTree);
        }
    }

    static <T extends Positionable> void removeQuadTreeRef(T ref){
        if (ref instanceof QuadTreeAware){
            ((QuadTreeAware) ref).setQuad(null);
        }
    }
}
