/*******************************************************************************
 * Copyright 2019 See AUTHORS file
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.mini2Dx.core.exception;

/**
 * Thrown when a required field has a null value during serialization
 */
public class RequiredFieldException extends SerializationException {
	private static final long serialVersionUID = 7417382284940976911L;

	public RequiredFieldException(Class<?> clazz, String fieldName) {
		super("Field '" + fieldName + "' requires a value during reading/writing of class '" + clazz.getName() + "'");
	}
}
