/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core;

import org.mini2Dx.core.di.BeanUtils;
import org.mini2Dx.core.di.ComponentScanner;
import org.mini2Dx.core.di.bean.Bean;
import org.mini2Dx.core.di.injection.BeanInjector;
import org.mini2Dx.gdx.utils.OrderedMap;

public class DependencyInjection {
    private final OrderedMap<String, Object> presetSingletons = new OrderedMap();
    private final OrderedMap<String, Object> presetPrototypes = new OrderedMap();
    private final BeanUtils beanUtils = new BeanUtils();
    private final ComponentScanner componentScanner;
    private OrderedMap<String, Bean> beans;

    public DependencyInjection(ComponentScanner componentScanner) {
        this.componentScanner = componentScanner;
    }

    public <T> void presetSingleton(T ref, Class<T> clazz) {
        this.presetSingletons.put((Object)Bean.getClassKey(clazz), ref);
    }

    public <T> void presetSingleton(Class<T> clazz) throws Exception {
        this.presetSingletons.put((Object)Bean.getClassKey(clazz), clazz.newInstance());
    }

    public <T> void presetPrototype(Class<T> clazz) throws Exception {
        this.presetPrototypes.put((Object)Bean.getClassKey(clazz), clazz.newInstance());
    }

    public void scan(String ... packageNames) throws Exception {
        String key;
        this.componentScanner.scan(packageNames);
        OrderedMap singletons = new OrderedMap(this.presetSingletons);
        OrderedMap prototypes = new OrderedMap(this.presetPrototypes);
        for (Class clazz : this.componentScanner.getSingletonClasses()) {
            key = Bean.getClassKey(clazz);
            singletons.put((Object)key, clazz.newInstance());
        }
        for (Class clazz : this.componentScanner.getPrototypeClasses()) {
            key = Bean.getClassKey(clazz);
            prototypes.put((Object)key, clazz.newInstance());
        }
        BeanInjector injector = new BeanInjector((OrderedMap<String, Object>)singletons, (OrderedMap<String, Object>)prototypes);
        injector.inject();
        this.beans = injector.getInjectionResult();
    }

    public <T> T getBean(Class<T> clazz) {
        String classKey = Bean.getClassKey(clazz);
        if (this.beans == null) {
            return null;
        }
        if (!this.beans.containsKey((Object)classKey)) {
            return null;
        }
        return (T)((Bean)this.beans.get((Object)classKey)).getInstance();
    }

    public ComponentScanner getComponentScanner() {
        return this.componentScanner;
    }

    public BeanUtils beanUtils() {
        return this.beanUtils;
    }
}

