/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core;

import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.EquilateralTriangle;
import org.mini2Dx.core.geom.Line;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.RegularHexagon;
import org.mini2Dx.core.geom.RegularPentagon;
import org.mini2Dx.core.geom.Triangle;
import org.mini2Dx.gdx.utils.Queue;

public class Geometry {
    public static int DEFAULT_POOL_SIZE = 256;
    final Queue<Circle> circles = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<EquilateralTriangle> equilateralTriangles = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<Line> lines = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<LineSegment> lineSegments = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<Point> points = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<Polygon> polygons = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<Rectangle> rectangles = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<RegularHexagon> regularHexagons = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<RegularPentagon> regularPentagons = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<Triangle> triangles = new Queue(DEFAULT_POOL_SIZE * 2);
    private boolean initialised = false;

    public Geometry() {
        this.init();
    }

    public void init() {
        if (this.initialised) {
            return;
        }
        for (int i = 0; i < DEFAULT_POOL_SIZE; ++i) {
            this.circles.addLast((Object)new Circle(this));
            this.equilateralTriangles.addLast((Object)new EquilateralTriangle(this));
            this.lines.addLast((Object)new Line(this));
            this.lineSegments.addLast((Object)new LineSegment(this));
            this.points.addLast((Object)new Point(this));
            this.rectangles.addLast((Object)new Rectangle(this));
            this.regularHexagons.addLast((Object)new RegularHexagon(this));
            this.regularPentagons.addLast((Object)new RegularPentagon(this));
        }
        this.initialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Circle circle() {
        Queue<Circle> queue = this.circles;
        synchronized (queue) {
            if (this.circles.size == 0) {
                return new Circle(this);
            }
            Circle result = (Circle)this.circles.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Circle circle) {
        Queue<Circle> queue = this.circles;
        synchronized (queue) {
            this.circles.addLast((Object)circle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EquilateralTriangle equilateralTriangle() {
        Queue<EquilateralTriangle> queue = this.equilateralTriangles;
        synchronized (queue) {
            if (this.equilateralTriangles.size == 0) {
                return new EquilateralTriangle(this);
            }
            EquilateralTriangle result = (EquilateralTriangle)this.equilateralTriangles.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(EquilateralTriangle equilateralTriangle) {
        Queue<EquilateralTriangle> queue = this.equilateralTriangles;
        synchronized (queue) {
            this.equilateralTriangles.addLast((Object)equilateralTriangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line line() {
        Queue<Line> queue = this.lines;
        synchronized (queue) {
            if (this.lines.size == 0) {
                return new Line(this);
            }
            Line result = (Line)this.lines.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Line line) {
        Queue<Line> queue = this.lines;
        synchronized (queue) {
            this.lines.addLast((Object)line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineSegment lineSegment() {
        Queue<LineSegment> queue = this.lineSegments;
        synchronized (queue) {
            if (this.lineSegments.size == 0) {
                return new LineSegment(this);
            }
            LineSegment result = (LineSegment)this.lineSegments.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(LineSegment lineSegment) {
        Queue<LineSegment> queue = this.lineSegments;
        synchronized (queue) {
            this.lineSegments.addLast((Object)lineSegment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point point() {
        Queue<Point> queue = this.points;
        synchronized (queue) {
            if (this.points.size == 0) {
                return new Point(this);
            }
            Point result = (Point)this.points.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Point point) {
        Queue<Point> queue = this.points;
        synchronized (queue) {
            this.points.addLast((Object)point);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Polygon polygon() {
        Queue<Polygon> queue = this.polygons;
        synchronized (queue) {
            if (this.polygons.size == 0) {
                return this.polygon(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
            }
            Polygon result = (Polygon)this.polygons.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Polygon polygon(float[] vertices) {
        Queue<Polygon> queue = this.polygons;
        synchronized (queue) {
            if (this.polygons.size == 0) {
                return new Polygon(this, vertices);
            }
            Polygon result = (Polygon)this.polygons.removeFirst();
            result.setVertices(vertices);
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Polygon polygon) {
        Queue<Polygon> queue = this.polygons;
        synchronized (queue) {
            this.polygons.addLast((Object)polygon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle rectangle() {
        Queue<Rectangle> queue = this.rectangles;
        synchronized (queue) {
            if (this.rectangles.size == 0) {
                return new Rectangle(this);
            }
            Rectangle result = (Rectangle)this.rectangles.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Rectangle rectangle) {
        Queue<Rectangle> queue = this.rectangles;
        synchronized (queue) {
            this.rectangles.addLast((Object)rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegularHexagon regularHexagon() {
        Queue<RegularHexagon> queue = this.regularHexagons;
        synchronized (queue) {
            if (this.regularHexagons.size == 0) {
                return new RegularHexagon(this);
            }
            RegularHexagon result = (RegularHexagon)this.regularHexagons.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(RegularHexagon regularHexagon) {
        Queue<RegularHexagon> queue = this.regularHexagons;
        synchronized (queue) {
            this.regularHexagons.addLast((Object)regularHexagon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegularPentagon regularPentagon() {
        Queue<RegularPentagon> queue = this.regularPentagons;
        synchronized (queue) {
            if (this.regularPentagons.size == 0) {
                return new RegularPentagon(this);
            }
            RegularPentagon result = (RegularPentagon)this.regularPentagons.removeFirst();
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(RegularPentagon regularPentagon) {
        Queue<RegularPentagon> queue = this.regularPentagons;
        synchronized (queue) {
            this.regularPentagons.addLast((Object)regularPentagon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Triangle triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        Queue<Triangle> queue = this.triangles;
        synchronized (queue) {
            if (this.triangles.size == 0) {
                return new Triangle(this, x1, y1, x2, y2, x3, y3);
            }
            Triangle result = (Triangle)this.triangles.removeFirst();
            result.setPosition(x1, y1, x2, y2, x3, y3);
            result.setDisposed(false);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Triangle triangle) {
        Queue<Triangle> queue = this.triangles;
        synchronized (queue) {
            this.triangles.addLast((Object)triangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCirclesAvailable() {
        Queue<Circle> queue = this.circles;
        synchronized (queue) {
            return this.circles.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalEquilateralTrianglesAvailable() {
        Queue<EquilateralTriangle> queue = this.equilateralTriangles;
        synchronized (queue) {
            return this.equilateralTriangles.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalLinesAvailable() {
        Queue<Line> queue = this.lines;
        synchronized (queue) {
            return this.lines.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalLineSegmentsAvailable() {
        Queue<LineSegment> queue = this.lineSegments;
        synchronized (queue) {
            return this.lineSegments.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalPointsAvailable() {
        Queue<Point> queue = this.points;
        synchronized (queue) {
            return this.points.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalPolygonsAvailable() {
        Queue<Polygon> queue = this.polygons;
        synchronized (queue) {
            return this.polygons.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRectanglesAvailable() {
        Queue<Rectangle> queue = this.rectangles;
        synchronized (queue) {
            return this.rectangles.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRegularHexagonsAvailable() {
        Queue<RegularHexagon> queue = this.regularHexagons;
        synchronized (queue) {
            return this.regularHexagons.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRegularPentagonsAvailable() {
        Queue<RegularPentagon> queue = this.regularPentagons;
        synchronized (queue) {
            return this.regularPentagons.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalTrianglesAvailable() {
        Queue<Triangle> queue = this.triangles;
        synchronized (queue) {
            return this.triangles.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupCircles(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<Circle> queue = this.circles;
            synchronized (queue) {
                this.circles.addLast((Object)new Circle(this));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupEquilateralTriangles(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<EquilateralTriangle> queue = this.equilateralTriangles;
            synchronized (queue) {
                this.equilateralTriangles.addLast((Object)new EquilateralTriangle(this));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupLines(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<Line> queue = this.lines;
            synchronized (queue) {
                this.lines.addLast((Object)new Line(this));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupLineSegments(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<LineSegment> queue = this.lineSegments;
            synchronized (queue) {
                this.lineSegments.addLast((Object)new LineSegment(this));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupRectangles(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<Rectangle> queue = this.rectangles;
            synchronized (queue) {
                this.rectangles.addLast((Object)new Rectangle(this));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupRegularHexagons(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<RegularHexagon> queue = this.regularHexagons;
            synchronized (queue) {
                this.regularHexagons.addLast((Object)new RegularHexagon(this));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupRegualarPentagons(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<RegularPentagon> queue = this.regularPentagons;
            synchronized (queue) {
                this.regularPentagons.addLast((Object)new RegularPentagon(this));
                continue;
            }
        }
    }
}

