/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core;

import java.util.Locale;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.font.FontGlyphLayout;
import org.mini2Dx.core.util.InterpolationTracker;

public class PerformanceTracker {
    private static final String UPDATE_DURATION_PREFIX = "Avg update duration:: ";
    private static final String MAX_PREFIX = ", Max:: ";
    private static final String INTERPOLATE_DURATION_PREFIX = "Avg interpolate duration:: ";
    private static final String RENDER_DURATION_PREFIX = "Avg render duration:: ";
    private static final String FRAME_DURATION_PREFIX = "Avg frame duration:: ";
    private static final String FRAME_INTERVAL_PREFIX = "Avg frame interval:: ";
    private static final String UPDATE_PREFIX = "Updates / second:: ";
    private static final String FRAMES_PREFIX = "Frames / second:: ";
    private static final String MEMORY_PREFIX = "Memory usage:: ";
    private static final String INTERPOLATABLES_PREFIX = "Interpolating Objects:: ";
    private static final String MS = "ms";
    private static final String[] messages = new String[9];
    private static long lastMessagesUpdate = 0L;
    private static FontGlyphLayout glyphLayout;

    public static void draw(Graphics g, float x, float y) {
        PerformanceTracker.draw(g, x, y, -1.0f, 0);
    }

    public static void draw(Graphics g, float x, float y, float targetWidth, int horizontalAlign) {
        PerformanceTracker.updateMessages();
        float lineHeight = PerformanceTracker.getLineHeight(g);
        for (int i = 0; i < messages.length; ++i) {
            float computedY = y + lineHeight * (float)i + 1.0f * (float)i;
            if (targetWidth < 0.0f) {
                g.drawString(messages[i], x, computedY);
                continue;
            }
            g.drawString(messages[i], x, computedY, targetWidth, horizontalAlign);
        }
    }

    public static void drawInTopLeft(Graphics g) {
        PerformanceTracker.draw(g, 0.0f, 0.0f);
    }

    public static void drawInTopRight(Graphics g) {
        PerformanceTracker.updateMessages();
        float textWidth = PerformanceTracker.getLineWidth(g);
        PerformanceTracker.draw(g, g.getViewportWidth() - textWidth - 1.0f, 0.0f, textWidth, 16);
    }

    public static void drawInBottomLeft(Graphics g) {
        PerformanceTracker.updateMessages();
        float textHeight = PerformanceTracker.getLineHeight(g) * (float)messages.length + (float)messages.length;
        PerformanceTracker.draw(g, 0.0f, g.getViewportHeight() - textHeight - 1.0f, -1.0f, 8);
    }

    public static void drawInBottomRight(Graphics g) {
        PerformanceTracker.updateMessages();
        float textWidth = PerformanceTracker.getLineWidth(g);
        float textHeight = PerformanceTracker.getLineHeight(g) * (float)messages.length + (float)messages.length;
        PerformanceTracker.draw(g, g.getViewportWidth() - textWidth - 1.0f, g.getViewportHeight() - textHeight - 1.0f, textWidth, 16);
    }

    private static void updateMessages() {
        long currentTime = Mdx.platformUtils.currentTimeMillis();
        if (currentTime - lastMessagesUpdate < 1000L) {
            return;
        }
        lastMessagesUpdate = currentTime;
        PerformanceTracker.messages[0] = UPDATE_DURATION_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getAverageUpdateDuration() / 1000000.0) + MS + MAX_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getMaxUpdateDuration() / 1000000.0) + MS;
        PerformanceTracker.messages[1] = INTERPOLATE_DURATION_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getAverageInterpolateDuration() / 1000000.0) + MS + MAX_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getMaxInterpolateDuration() / 1000000.0) + MS;
        PerformanceTracker.messages[2] = RENDER_DURATION_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getAverageRenderDuration() / 1000000.0) + MS + MAX_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getMaxRenderDuration() / 1000000.0) + MS;
        PerformanceTracker.messages[3] = FRAME_DURATION_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getAverageFrameDuration() / 1000000.0) + MS + MAX_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getMaxFrameDuration() / 1000000.0) + MS;
        PerformanceTracker.messages[4] = FRAME_INTERVAL_PREFIX + String.format(Locale.ENGLISH, "%.3f", Mdx.platformUtils.getAverageFrameInterval() / 1000000.0) + MS;
        PerformanceTracker.messages[5] = UPDATE_PREFIX + Mdx.platformUtils.getUpdatesPerSecond();
        PerformanceTracker.messages[6] = FRAMES_PREFIX + Mdx.platformUtils.getFramesPerSecond();
        PerformanceTracker.messages[7] = MEMORY_PREFIX + PerformanceTracker.getHumanReadableByteValue(Mdx.platformUtils.getUsedMemory()) + "/" + PerformanceTracker.getHumanReadableByteValue(Mdx.platformUtils.getTotalMemory());
        PerformanceTracker.messages[8] = INTERPOLATABLES_PREFIX + InterpolationTracker.getTotalObjects();
    }

    private static float getLineWidth(Graphics g) {
        if (glyphLayout == null) {
            glyphLayout = g.getFont().newGlyphLayout();
        }
        float lineWidth = 0.0f;
        for (int i = 0; i < messages.length; ++i) {
            glyphLayout.setText(messages[i]);
            if (!(glyphLayout.getWidth() > lineWidth)) continue;
            lineWidth = glyphLayout.getWidth();
        }
        return lineWidth;
    }

    private static float getLineHeight(Graphics g) {
        if (glyphLayout == null) {
            glyphLayout = g.getFont().newGlyphLayout();
        }
        float lineHeight = 0.0f;
        for (int i = 0; i < messages.length; ++i) {
            glyphLayout.setText(messages[i]);
            if (!(glyphLayout.getHeight() > lineHeight)) continue;
            lineHeight = glyphLayout.getHeight();
        }
        return lineHeight;
    }

    private static String getHumanReadableByteValue(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format(Locale.ENGLISH, "%.1f %ciB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }
}

