/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core;

import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.util.RollingAverage;
import org.mini2Dx.core.util.RollingMax;
import org.mini2Dx.core.util.ZlibStream;

public abstract class PlatformUtils {
    private long updateSecondStart;
    private long updateStartNanos;
    private int updates;
    private int updatesPerSecond;
    private final RollingAverage averageUpdateDuration = new RollingAverage(GameContainer.TARGET_FPS);
    private final RollingMax maxUpdateDuration = new RollingMax(GameContainer.TARGET_FPS);
    private long interpolateStartNanos;
    private final RollingAverage averageInterpolateDuration = new RollingAverage(GameContainer.TARGET_FPS);
    private final RollingMax maxInterpolateDuration = new RollingMax(GameContainer.TARGET_FPS);
    private long renderStartNanos;
    private final RollingAverage averageRenderDuration = new RollingAverage(GameContainer.TARGET_FPS);
    private final RollingMax maxRenderDuration = new RollingMax(GameContainer.TARGET_FPS);
    private long frameStartNanos;
    private final RollingAverage averageFrameInterval = new RollingAverage(GameContainer.TARGET_FPS);
    private final RollingAverage averageFrameDuration = new RollingAverage(GameContainer.TARGET_FPS);
    private final RollingMax maxFrameDuration = new RollingMax(GameContainer.TARGET_FPS);
    private long frameSecondStart;
    private int frames;
    private int framesPerSecond;

    public abstract void exit(boolean var1);

    public abstract long nanoTime();

    public abstract long currentTimeMillis();

    public abstract long getTotalMemory();

    public abstract long getAvailableMemory();

    public abstract long getUsedMemory();

    public abstract boolean isGameThread();

    public abstract void enablePerformanceMode();

    public abstract void cancelPerformanceMode();

    public void markUpdateBegin() {
        long time = this.nanoTime();
        if (time - this.updateSecondStart >= 1000000000L) {
            this.updatesPerSecond = this.updates;
            this.updates = 0;
            this.updateSecondStart = time;
        }
        ++this.updates;
        this.updateStartNanos = this.nanoTime();
    }

    public void markInterpolateBegin() {
        this.interpolateStartNanos = this.nanoTime();
    }

    public void markInterpolateEnd() {
        long time = this.nanoTime();
        long interpolateDuration = time - this.interpolateStartNanos;
        this.averageInterpolateDuration.mark(interpolateDuration);
        this.maxInterpolateDuration.mark(interpolateDuration);
    }

    public void markRenderBegin() {
        this.renderStartNanos = this.nanoTime();
    }

    public void markRenderEnd() {
        long time = this.nanoTime();
        long renderDuration = time - this.renderStartNanos;
        this.averageRenderDuration.mark(renderDuration);
        this.maxRenderDuration.mark(renderDuration);
    }

    public void markUpdateEnd() {
        long time = this.nanoTime();
        long updateDuration = time - this.updateStartNanos;
        this.averageUpdateDuration.mark(updateDuration);
        this.maxUpdateDuration.mark(updateDuration);
    }

    public void markFrameBegin() {
        long time = this.nanoTime();
        if (this.frameStartNanos != 0L) {
            this.averageFrameInterval.mark(time - this.frameStartNanos);
        }
        this.frameStartNanos = time;
        if (time - this.frameSecondStart >= 1000000000L) {
            this.framesPerSecond = this.frames;
            this.frames = 0;
            this.frameSecondStart = time;
        }
        ++this.frames;
    }

    public void markFrameEnd() {
        long time = this.nanoTime();
        long frameDuration = time - this.frameStartNanos;
        this.averageFrameDuration.mark(frameDuration);
        this.maxFrameDuration.mark(frameDuration);
    }

    public int getUpdatesPerSecond() {
        return this.updatesPerSecond;
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public int getUpdatesThisSecond() {
        return this.updates;
    }

    public double getAverageUpdateDuration() {
        return this.averageUpdateDuration.getAverage();
    }

    public double getMaxUpdateDuration() {
        return this.maxUpdateDuration.getMax();
    }

    public double getAverageInterpolateDuration() {
        return this.averageInterpolateDuration.getAverage();
    }

    public double getMaxInterpolateDuration() {
        return this.maxInterpolateDuration.getMax();
    }

    public double getAverageRenderDuration() {
        return this.averageRenderDuration.getAverage();
    }

    public double getMaxRenderDuration() {
        return this.maxRenderDuration.getMax();
    }

    public double getAverageFrameInterval() {
        return this.averageFrameInterval.getAverage();
    }

    public double getAverageFrameDuration() {
        return this.averageFrameDuration.getAverage();
    }

    public double getMaxFrameDuration() {
        return this.maxFrameDuration.getMax();
    }

    public abstract ZlibStream decompress(byte[] var1);

    public abstract String timestampToDateFormat(long var1, String var3);
}

