/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.PlayerDataException;
import org.mini2Dx.core.exception.SerializationException;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.serialization.GameDataOutputStream;

public abstract class PlayerData {
    private static final String LOGGING_TAG = PlayerData.class.getSimpleName();

    protected abstract FileHandle resolve(String[] var1);

    protected abstract FileHandle resolveTmp(String[] var1);

    protected abstract void ensureDataDirectoryExists() throws IOException;

    public abstract boolean isDataStorageFull() throws Exception;

    public abstract boolean isDataStorageConnected();

    public abstract void wipe() throws PlayerDataException, IOException;

    public FileHandle getFileHandle(String ... filepath) {
        return this.resolve(filepath);
    }

    public <T> T readXml(Class<T> clazz, String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        try {
            InputStream inputStream = this.resolve(filepath).read();
            T result = Mdx.xml.fromXml(new InputStreamReader(inputStream), clazz);
            inputStream.close();
            return result;
        }
        catch (SerializationException e) {
            throw new PlayerDataException(e);
        }
        catch (IOException e) {
            throw new PlayerDataException(e);
        }
    }

    public <T> void writeXml(T object, String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        try {
            this.ensureDirectoryExistsForFile(filepath);
            StringWriter writer = new StringWriter();
            Mdx.xml.toXml(object, writer);
            FileHandle file = this.resolve(filepath);
            FileHandle tmpFile = this.resolveTmp(filepath);
            tmpFile.writeString(writer.toString(), false);
            writer.flush();
            writer.close();
            if (file.exists()) {
                file.delete();
            }
            tmpFile.moveTo(file);
        }
        catch (SerializationException e) {
            throw new PlayerDataException(e);
        }
        catch (IOException e) {
            throw new PlayerDataException(e);
        }
    }

    public <T> T readJson(Class<T> clazz, String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        try {
            return Mdx.json.fromJson(this.resolve(filepath).readString(), clazz);
        }
        catch (SerializationException e) {
            throw new PlayerDataException(e);
        }
        catch (IOException e) {
            throw new PlayerDataException(e);
        }
    }

    public <T> void writeJson(T object, String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        try {
            this.ensureDirectoryExistsForFile(filepath);
            FileHandle file = this.resolve(filepath);
            FileHandle tmpFile = this.resolveTmp(filepath);
            tmpFile.writeString(Mdx.json.toJson(object), false);
            if (file.exists()) {
                file.delete();
            }
            tmpFile.moveTo(file);
        }
        catch (SerializationException e) {
            throw new PlayerDataException(e);
        }
        catch (IOException e) {
            throw new PlayerDataException(e);
        }
    }

    public DataInputStream readBytes(String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        try {
            FileHandle file = this.resolve(filepath);
            InputStream inputStream = file.read();
            return new DataInputStream(new BufferedInputStream(inputStream));
        }
        catch (Exception e) {
            throw new PlayerDataException(e);
        }
    }

    public DataOutputStream writeBytes(String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        try {
            this.ensureDirectoryExistsForFile(filepath);
            final FileHandle file = this.resolve(filepath);
            final FileHandle tmpFile = this.resolveTmp(filepath);
            OutputStream outputStream = tmpFile.write(false);
            GameDataOutputStream result = new GameDataOutputStream(new BufferedOutputStream(outputStream));
            result.setCloseListener(new GameDataOutputStream.CloseListener(){

                @Override
                public void onClose() {
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                        tmpFile.moveTo(file);
                    }
                    catch (Exception e) {
                        Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
                    }
                }
            });
            return result;
        }
        catch (Exception e) {
            throw new PlayerDataException(e);
        }
    }

    public String readString(String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        try {
            FileHandle file = this.resolve(filepath);
            return file.readString();
        }
        catch (Exception e) {
            throw new PlayerDataException(e);
        }
    }

    public void writeString(String content, String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        try {
            this.ensureDirectoryExistsForFile(filepath);
            FileHandle file = this.resolve(filepath);
            FileHandle tmpFile = this.resolveTmp(filepath);
            tmpFile.writeString(content, false);
            if (file.exists()) {
                file.delete();
            }
            tmpFile.moveTo(file);
        }
        catch (Exception e) {
            throw new PlayerDataException(e);
        }
    }

    public boolean delete(String ... path) throws PlayerDataException {
        if (path.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        FileHandle file = this.resolve(path);
        try {
            if (file.isDirectory()) {
                return file.deleteDirectory();
            }
            return file.delete();
        }
        catch (IOException e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            return false;
        }
    }

    public boolean hasFile(String ... filepath) throws PlayerDataException {
        if (filepath.length == 0) {
            throw new PlayerDataException("No file path specified");
        }
        FileHandle file = this.resolve(filepath);
        if (file.exists()) {
            return !file.isDirectory();
        }
        return false;
    }

    public boolean hasDirectory(String ... path) throws PlayerDataException {
        if (path.length == 0) {
            throw new PlayerDataException("No path specified");
        }
        FileHandle directoryHandle = this.resolve(path);
        if (directoryHandle.exists()) {
            return directoryHandle.isDirectory();
        }
        return false;
    }

    public void createDirectory(String ... path) throws PlayerDataException {
        if (path.length == 0) {
            throw new PlayerDataException("No path specified");
        }
        FileHandle directory = this.resolve(path);
        if (directory.exists()) {
            return;
        }
        try {
            this.ensureDataDirectoryExists();
            directory.mkdirs();
        }
        catch (Exception e) {
            throw new PlayerDataException(e);
        }
    }

    protected void ensureDirectoryExistsForFile(String ... filepath) throws IOException, PlayerDataException {
        this.ensureDataDirectoryExists();
        FileHandle file = this.resolve(filepath);
        if (file.exists()) {
            return;
        }
        FileHandle parent = file.parent();
        if (parent.exists()) {
            return;
        }
        parent.mkdirs();
    }
}

