/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.assets;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetLoader;
import org.mini2Dx.core.assets.AssetLoaderResult;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.assets.AsyncAssetLoader;
import org.mini2Dx.core.assets.AsyncLoadingCache;
import org.mini2Dx.core.assets.ReferenceCountedObject;
import org.mini2Dx.core.executor.AsyncFuture;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;

public class AssetLoadingTask<T>
implements Runnable,
Comparable<AssetLoadingTask>,
Disposable {
    private static final String LOGGING_TAG = AssetLoadingTask.class.getSimpleName();
    private final AssetLoaderResult<T> assetLoaderResult = new AssetLoaderResult();
    private final AssetLoader<T> assetLoader;
    private final AssetDescriptor<T> assetDescriptor;
    private final long taskSubmissionTimeNanos;
    private Array<AssetDescriptor> dependencies;
    private boolean dependenciesRetrieved = false;
    private boolean dependenciesQueued = false;
    private boolean dependenciesLoaded = false;
    private boolean asyncCompleted;
    private AsyncFuture asyncFuture;
    private AsyncLoadingCache asyncLoadingCache;

    public AssetLoadingTask(AssetLoader<T> assetLoader, AssetDescriptor<T> assetDescriptor) {
        this.assetLoader = assetLoader;
        this.assetDescriptor = assetDescriptor;
        this.taskSubmissionTimeNanos = System.nanoTime();
        if (assetLoader instanceof AsyncAssetLoader) {
            this.asyncLoadingCache = new AsyncLoadingCache();
        } else {
            this.asyncCompleted = true;
        }
    }

    public boolean update(AssetManager assetManager) {
        if (!this.dependenciesRetrieved) {
            this.dependencies = this.assetLoader.getDependencies(this.assetDescriptor, this.asyncLoadingCache);
            this.dependenciesRetrieved = true;
            this.dependenciesLoaded = this.dependenciesQueued = this.dependencies == null;
            return false;
        }
        if (!this.dependenciesQueued) {
            for (int i = 0; i < this.dependencies.size; ++i) {
                assetManager.load((AssetDescriptor)this.dependencies.get(i));
            }
            this.dependenciesQueued = true;
            return false;
        }
        if (!this.dependenciesLoaded) {
            for (int i = 0; i < this.dependencies.size; ++i) {
                if (assetManager.isLoaded(((AssetDescriptor)this.dependencies.get(i)).getFilePath())) continue;
                return false;
            }
            this.dependenciesLoaded = true;
        }
        if (!this.asyncCompleted) {
            if (this.asyncFuture == null) {
                this.asyncFuture = Mdx.executor.submit(this);
            }
            this.asyncCompleted = this.asyncFuture.isFinished();
            return false;
        }
        if (this.assetLoader.loadOnGameThread(assetManager, this.assetDescriptor, this.asyncLoadingCache, this.assetLoaderResult)) {
            assetManager.getAssets().put((Object)this.assetDescriptor.getFilePath(), (Object)new ReferenceCountedObject(this.assetLoaderResult.getResult()));
            assetManager.getAssetDescriptors().put((Object)this.assetDescriptor.getFilePath(), this.assetDescriptor);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            AsyncAssetLoader asyncAssetLoader = (AsyncAssetLoader)this.assetLoader;
            asyncAssetLoader.loadOnAsyncThread(this.assetDescriptor, this.asyncLoadingCache);
        }
        catch (Exception e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
        }
    }

    @Override
    public int compareTo(AssetLoadingTask o) {
        int dependenciesCompare = Integer.compare(o.getTotalDependencies(), this.getTotalDependencies());
        if (dependenciesCompare == 0) {
            return Long.compare(this.taskSubmissionTimeNanos, o.taskSubmissionTimeNanos);
        }
        return dependenciesCompare;
    }

    public int getTotalDependencies() {
        if (!this.dependenciesRetrieved) {
            return -1;
        }
        if (this.dependencies == null) {
            return 0;
        }
        return this.dependencies.size;
    }

    public void dispose() {
        if (this.asyncLoadingCache != null) {
            this.asyncLoadingCache.clearCache();
            this.asyncLoadingCache = null;
        }
        if (this.dependencies != null) {
            this.dependencies.clear();
            this.dependencies = null;
        }
        this.asyncFuture = null;
    }
}

