/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.assets;

import java.util.concurrent.TimeUnit;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetLoader;
import org.mini2Dx.core.assets.AssetLoadingTask;
import org.mini2Dx.core.assets.AssetProperties;
import org.mini2Dx.core.assets.ReferenceCountedObject;
import org.mini2Dx.core.assets.loader.MusicLoader;
import org.mini2Dx.core.assets.loader.PixmapLoader;
import org.mini2Dx.core.assets.loader.ShaderLoader;
import org.mini2Dx.core.assets.loader.SoundLoader;
import org.mini2Dx.core.assets.loader.TextureAtlasLoader;
import org.mini2Dx.core.assets.loader.TextureLoader;
import org.mini2Dx.core.audio.Music;
import org.mini2Dx.core.audio.Sound;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.files.FileHandleResolver;
import org.mini2Dx.core.graphics.Pixmap;
import org.mini2Dx.core.graphics.Shader;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;
import org.mini2Dx.gdx.utils.ObjectMap;

public class AssetManager
implements Disposable {
    private static final String LOGGING_TAG = AssetManager.class.getSimpleName();
    public static long UPDATE_TIMEBOX_MILLIS = 4L;
    private final FileHandleResolver fileHandleResolver;
    private final ObjectMap<Class, AssetLoader> assetLoaders = new ObjectMap();
    private final ObjectMap<String, ReferenceCountedObject> assets = new ObjectMap();
    private final ObjectMap<String, AssetDescriptor> assetDescriptors = new ObjectMap();
    private final Array<AssetDescriptor> loadingQueue = new Array(false, 32);
    private final Array<AssetLoadingTask> loadingTasks = new Array(false, 32);
    private float queuedAssets = 0.0f;
    private float completedTasks = 0.0f;
    private boolean loadingTasksDirty = false;

    public AssetManager(FileHandleResolver fileHandleResolver) {
        this(fileHandleResolver, true);
    }

    public AssetManager(FileHandleResolver fileHandleResolver, boolean initDefaultLoaders) {
        this.fileHandleResolver = fileHandleResolver;
        if (initDefaultLoaders) {
            this.assetLoaders.put(Music.class, (Object)new MusicLoader());
            this.assetLoaders.put(Pixmap.class, (Object)new PixmapLoader());
            this.assetLoaders.put(Shader.class, (Object)new ShaderLoader());
            this.assetLoaders.put(Sound.class, (Object)new SoundLoader());
            this.assetLoaders.put(Texture.class, (Object)new TextureLoader());
            this.assetLoaders.put(TextureAtlas.class, (Object)new TextureAtlasLoader());
        }
    }

    public <T> T get(String filePath, Class<T> clazz) {
        if (!this.assets.containsKey((Object)filePath)) {
            throw new MdxException(filePath + " not yet loaded");
        }
        return ((ReferenceCountedObject)this.assets.get((Object)filePath)).getObject(clazz);
    }

    public <T> ObjectMap<String, T> getAll(Class<T> clazz) {
        ObjectMap assetsOfType = new ObjectMap();
        this.assetDescriptors.entries().forEach(assetDescriptorEntry -> {
            if (((AssetDescriptor)assetDescriptorEntry.value).getClazz().equals(clazz)) {
                assetsOfType.put(assetDescriptorEntry.key, ((ReferenceCountedObject)this.assets.get(assetDescriptorEntry.key)).getObject(clazz));
            }
        });
        return assetsOfType;
    }

    public boolean isLoaded(String filePath) {
        return this.assets.containsKey((Object)filePath);
    }

    public <T> void load(String filePath, Class<T> clazz) {
        this.load(new AssetDescriptor<T>(filePath, clazz));
    }

    public <T> void load(String filePath, Class<T> clazz, AssetProperties assetProperties) {
        this.load(new AssetDescriptor<T>(filePath, clazz, assetProperties));
    }

    public void load(AssetDescriptor assetDescriptor) {
        if (this.assets.containsKey((Object)assetDescriptor.getFilePath())) {
            return;
        }
        if (!this.assetLoaders.containsKey(assetDescriptor.getClazz())) {
            throw new MdxException("No asset loader configured for " + assetDescriptor.getClazz().getName());
        }
        for (int i = 0; i < this.loadingQueue.size; ++i) {
            AssetDescriptor queuedDescriptor = (AssetDescriptor)this.loadingQueue.get(i);
            if (!queuedDescriptor.getFilePath().equals(assetDescriptor.getFilePath())) continue;
            if (!assetDescriptor.getClazz().equals(queuedDescriptor.getClazz())) {
                throw new MdxException(assetDescriptor.getFilePath() + " already queued but with a different class type (queued: " + queuedDescriptor.getClazz().getName() + ", attempting: " + assetDescriptor.getClazz().getName() + ")");
            }
            Mdx.log.debug(LOGGING_TAG, assetDescriptor.getFilePath() + " is already queued for loading");
            return;
        }
        this.loadingQueue.add((Object)assetDescriptor);
        this.queuedAssets += 1.0f;
    }

    public void unload(String filePath) {
        this.assets.remove((Object)filePath);
        this.assetDescriptors.remove((Object)filePath);
    }

    public boolean update() {
        long startTime = System.nanoTime();
        while (this.loadingQueue.size > 0) {
            AssetDescriptor assetDescriptor = (AssetDescriptor)this.loadingQueue.removeIndex(0);
            assetDescriptor.setResolvedFileHandle(this.fileHandleResolver.resolve(assetDescriptor.getFilePath()));
            AssetLoader assetLoader = (AssetLoader)this.assetLoaders.get(assetDescriptor.getClazz());
            this.loadingTasks.add(new AssetLoadingTask(assetLoader, assetDescriptor));
            this.loadingTasksDirty = true;
        }
        if (System.nanoTime() - startTime >= TimeUnit.MILLISECONDS.toNanos(UPDATE_TIMEBOX_MILLIS)) {
            return false;
        }
        if (this.loadingTasksDirty) {
            this.loadingTasks.sort();
            this.loadingTasksDirty = false;
        }
        if (System.nanoTime() - startTime >= TimeUnit.MILLISECONDS.toNanos(UPDATE_TIMEBOX_MILLIS)) {
            return false;
        }
        for (int i = this.loadingTasks.size - 1; i >= 0; --i) {
            if (((AssetLoadingTask)this.loadingTasks.get(i)).update(this)) {
                AssetLoadingTask task = (AssetLoadingTask)this.loadingTasks.removeIndex(i);
                task.dispose();
                this.completedTasks += 1.0f;
                this.loadingTasksDirty = true;
            }
            if (System.nanoTime() - startTime < TimeUnit.MILLISECONDS.toNanos(UPDATE_TIMEBOX_MILLIS)) continue;
            return false;
        }
        return this.loadingTasks.size == 0 && this.loadingQueue.size == 0;
    }

    public void finishLoading() {
        while (!this.update()) {
        }
    }

    public <T> void setAssetLoader(Class<T> clazz, AssetLoader<T> assetLoader) {
        this.assetLoaders.put(clazz, assetLoader);
    }

    public void clearAssetLoaders() {
        this.assetLoaders.clear();
    }

    public void dispose() {
        this.loadingQueue.clear();
    }

    public float getProgress() {
        return this.completedTasks / this.queuedAssets;
    }

    public float getQueuedAssets() {
        return this.queuedAssets;
    }

    public float getCompletedTasks() {
        return this.completedTasks;
    }

    public float getUnfinishedTasks() {
        return this.queuedAssets - this.completedTasks;
    }

    public FileHandleResolver getFileHandleResolver() {
        return this.fileHandleResolver;
    }

    ObjectMap<String, ReferenceCountedObject> getAssets() {
        return this.assets;
    }

    ObjectMap<String, AssetDescriptor> getAssetDescriptors() {
        return this.assetDescriptors;
    }
}

