/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.assets.loader;

import java.io.IOException;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetLoaderResult;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.assets.AsyncAssetLoader;
import org.mini2Dx.core.assets.AsyncLoadingCache;
import org.mini2Dx.core.audio.Music;
import org.mini2Dx.gdx.utils.Array;

public class MusicLoader
implements AsyncAssetLoader<Music> {
    private static final String LOGGING_TAG = MusicLoader.class.getSimpleName();
    private static final String CACHE_MUSIC_KEY = "music";

    @Override
    public boolean loadOnGameThread(AssetManager assetManager, AssetDescriptor<Music> assetDescriptor, AsyncLoadingCache asyncLoadingCache, AssetLoaderResult<Music> resultHolder) {
        resultHolder.setResult(asyncLoadingCache.getCache(CACHE_MUSIC_KEY, Music.class));
        return true;
    }

    @Override
    public void loadOnAsyncThread(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        if (asyncLoadingCache.containsCache(CACHE_MUSIC_KEY)) {
            return;
        }
        try {
            asyncLoadingCache.setCache(CACHE_MUSIC_KEY, Mdx.audio.newMusic(assetDescriptor.getResolvedFileHandle()));
        }
        catch (IOException e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
        }
    }

    @Override
    public Array<AssetDescriptor> getDependencies(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        return null;
    }
}

