/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.assets.loader;

import java.io.IOException;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetLoaderResult;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.assets.AsyncAssetLoader;
import org.mini2Dx.core.assets.AsyncLoadingCache;
import org.mini2Dx.core.audio.Sound;
import org.mini2Dx.gdx.utils.Array;

public class SoundLoader
implements AsyncAssetLoader<Sound> {
    private static final String LOGGING_TAG = SoundLoader.class.getSimpleName();
    private static final String CACHE_SOUND_KEY = "sound";

    @Override
    public boolean loadOnGameThread(AssetManager assetManager, AssetDescriptor<Sound> assetDescriptor, AsyncLoadingCache asyncLoadingCache, AssetLoaderResult<Sound> resultHolder) {
        resultHolder.setResult(asyncLoadingCache.getCache(CACHE_SOUND_KEY, Sound.class));
        return true;
    }

    @Override
    public void loadOnAsyncThread(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        try {
            asyncLoadingCache.setCache(CACHE_SOUND_KEY, Mdx.audio.newSound(assetDescriptor.getResolvedFileHandle()));
        }
        catch (IOException e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
        }
        catch (Exception e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
        }
    }

    @Override
    public Array<AssetDescriptor> getDependencies(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        return null;
    }
}

