/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.assets.loader;

import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetLoaderResult;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.assets.AsyncAssetLoader;
import org.mini2Dx.core.assets.AsyncLoadingCache;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.core.graphics.TextureAtlasConfig;
import org.mini2Dx.gdx.utils.Array;

public class TextureAtlasLoader
implements AsyncAssetLoader<TextureAtlas> {
    @Override
    public boolean loadOnGameThread(AssetManager assetManager, AssetDescriptor<TextureAtlas> assetDescriptor, AsyncLoadingCache asyncLoadingCache, AssetLoaderResult<TextureAtlas> resultHolder) {
        if (resultHolder.getResult() == null) {
            FileHandle resolvedFileHandle = assetDescriptor.getResolvedFileHandle();
            TextureAtlasConfig atlasConfig = asyncLoadingCache.getCache(resolvedFileHandle.path(), TextureAtlasConfig.class);
            for (String path : atlasConfig.textures.keySet()) {
                atlasConfig.textures.replace(path, assetManager.get(path, Texture.class));
            }
            resultHolder.setResult(new TextureAtlas(atlasConfig));
        }
        return resultHolder.getResult().loadAtlasRegionTextures();
    }

    @Override
    public Array<AssetDescriptor> getDependencies(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        FileHandle resolvedFileHandle = assetDescriptor.getResolvedFileHandle();
        TextureAtlasConfig atlasConfig = new TextureAtlasConfig(resolvedFileHandle);
        asyncLoadingCache.setCache(resolvedFileHandle.path(), atlasConfig);
        String[] dependenciesPaths = atlasConfig.getDependencies();
        Array descriptors = new Array(dependenciesPaths.length);
        for (String dependencyPath : dependenciesPaths) {
            descriptors.add(new AssetDescriptor<Texture>(dependencyPath, Texture.class));
        }
        return descriptors;
    }

    @Override
    public void loadOnAsyncThread(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
    }
}

