/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.assets.loader;

import java.io.IOException;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetLoaderResult;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.assets.AsyncAssetLoader;
import org.mini2Dx.core.assets.AsyncLoadingCache;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.gdx.utils.Array;

public class TextureLoader
implements AsyncAssetLoader<Texture> {
    private static final String LOGGING_TAG = TextureLoader.class.getSimpleName();
    private static final String CACHE_TEXTURE_DATA_KEY = "textureData";

    @Override
    public boolean loadOnGameThread(AssetManager assetManager, AssetDescriptor<Texture> assetDescriptor, AsyncLoadingCache asyncLoadingCache, AssetLoaderResult<Texture> resultHolder) {
        resultHolder.setResult(Mdx.graphics.newTexture(asyncLoadingCache.getCache(CACHE_TEXTURE_DATA_KEY, byte[].class)));
        asyncLoadingCache.removeCache(CACHE_TEXTURE_DATA_KEY);
        return true;
    }

    @Override
    public void loadOnAsyncThread(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        try {
            asyncLoadingCache.setCache(CACHE_TEXTURE_DATA_KEY, assetDescriptor.getResolvedFileHandle().readBytes());
        }
        catch (IOException e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
        }
        catch (Exception e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
        }
    }

    @Override
    public Array<AssetDescriptor> getDependencies(AssetDescriptor assetDescriptor, AsyncLoadingCache asyncLoadingCache) {
        return null;
    }
}

