/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.audio;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.mini2Dx.core.Audio;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.audio.Sound;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.executor.AsyncResult;
import org.mini2Dx.core.executor.FrameSpreadTask;
import org.mini2Dx.core.files.FileHandle;

public abstract class AsyncSoundResult
implements AsyncResult<Sound> {
    protected final FileHandle handle;
    private final AsyncResult<Object> result;
    private Sound cached;
    private boolean submittedToMainThread = false;

    public AsyncSoundResult(FileHandle file) {
        this.handle = file;
        this.result = Mdx.executor.submit(this.asyncReadFile(file));
    }

    @Override
    public boolean isFinished() {
        return this.result.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sound getResult() {
        if (!this.isFinished()) {
            return null;
        }
        if (this.cached != null) {
            return this.cached;
        }
        Sound s = this.makeSound(this.result);
        if (s != null) {
            this.cached = s;
            return s;
        }
        if (Mdx.platformUtils.isGameThread()) {
            Mdx.log.info("WARNING", "Async sound loading not supported on this platform, falling back to loading on main thread...");
            return this.loadFromFileHandle();
        }
        if (this.supportsLoadingAudioOnNonGameThread()) {
            Audio audio = Mdx.audio;
            synchronized (audio) {
                return this.loadFromFileHandle();
            }
        }
        if (this.submittedToMainThread) {
            return null;
        }
        Mdx.log.info("WARNING", "Async sound loading not supported on this platform, falling back to loading on main thread...");
        Mdx.executor.submit(new FrameSpreadTask(){

            @Override
            public boolean updateTask() {
                AsyncSoundResult.this.loadFromFileHandle();
                return true;
            }
        });
        this.submittedToMainThread = true;
        return null;
    }

    private Sound loadFromFileHandle() {
        try {
            this.cached = Mdx.audio.newSound(this.handle);
            return this.cached;
        }
        catch (IOException e) {
            throw new MdxException("Failed to load sound on game thread: ", e);
        }
    }

    protected abstract boolean supportsLoadingAudioOnNonGameThread();

    protected abstract Callable<Object> asyncReadFile(FileHandle var1);

    protected abstract Sound makeSound(AsyncResult<Object> var1);
}

