/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mini2Dx.core.exception.MdxException;

public class IntQueue {
    protected int[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;
    private IntQueueIterable iterable;

    public IntQueue() {
        this(16);
    }

    public IntQueue(int initialSize) {
        this.values = new int[initialSize];
    }

    public void addLast(int object) {
        int[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        values[this.tail++] = object;
        if (this.tail == values.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    public void addFirst(int object) {
        int[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        int head = this.head;
        if (--head == -1) {
            head = values.length - 1;
        }
        values[head] = object;
        this.head = head;
        ++this.size;
    }

    public void ensureCapacity(int additional) {
        int needed = this.size + additional;
        if (this.values.length < needed) {
            this.resize(needed);
        }
    }

    protected void resize(int newSize) {
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        int[] newArray = new int[newSize];
        if (head < tail) {
            System.arraycopy(values, head, newArray, 0, tail - head);
        } else if (this.size > 0) {
            int rest = values.length - head;
            System.arraycopy(values, head, newArray, 0, rest);
            System.arraycopy(values, 0, newArray, rest, tail);
        }
        this.values = newArray;
        this.head = 0;
        this.tail = this.size;
    }

    public int removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        int[] values = this.values;
        int result = values[this.head];
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    public int removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        int[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        int result = values[tail];
        this.tail = tail;
        --this.size;
        return result;
    }

    public int indexOf(int value) {
        if (this.size == 0) {
            return -1;
        }
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (head < tail) {
            for (int i = head; i < tail; ++i) {
                if (values[i] != value) continue;
                return i - head;
            }
        } else {
            int i;
            int n = values.length;
            for (i = head; i < n; ++i) {
                if (values[i] != value) continue;
                return i - head;
            }
            for (i = 0; i < tail; ++i) {
                if (values[i] != value) continue;
                return i + values.length - head;
            }
        }
        return -1;
    }

    public boolean removeValue(int value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return false;
        }
        this.removeIndex(index);
        return true;
    }

    public int removeIndex(int index) {
        int value;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int[] values = this.values;
        int head = this.head++;
        int tail = this.tail--;
        index += head;
        if (head < tail) {
            value = values[index];
            System.arraycopy(values, index + 1, values, index, tail - index);
        } else if (index >= values.length) {
            value = values[index -= values.length];
            System.arraycopy(values, index + 1, values, index, tail - index);
            --this.tail;
        } else {
            value = values[index];
            System.arraycopy(values, head, values, head + 1, index - head);
            if (this.head == values.length) {
                this.head = 0;
            }
        }
        --this.size;
        return value;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int first() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        return this.values[this.head];
    }

    public int last() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        int[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    public int get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        int[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        return values[i];
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public Iterator<Integer> iterator() {
        if (this.iterable == null) {
            this.iterable = new IntQueueIterable(this);
        }
        return this.iterable.iterator();
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(", ").append(values[i]);
            i = (i + 1) % values.length;
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        int[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(separator).append(values[i]);
            i = (i + 1) % values.length;
        }
        return sb.toString();
    }

    public int hashCode() {
        int size = this.size;
        int[] values = this.values;
        int backingLength = values.length;
        int index = this.head;
        int hash = size + 1;
        for (int s = 0; s < size; ++s) {
            int value = values[index];
            hash *= 31;
            hash += value;
            if (++index != backingLength) continue;
            index = 0;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntQueue)) {
            return false;
        }
        IntQueue q = (IntQueue)o;
        int size = this.size;
        if (q.size != size) {
            return false;
        }
        int[] myValues = this.values;
        int myBackingLength = myValues.length;
        int[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s = 0; s < size; ++s) {
            int myValue = myValues[myIndex];
            int itsValue = itsValues[itsIndex];
            if (myValue != itsValue) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }

    public static class IntQueueIterable
    implements Iterable<Integer> {
        private final IntQueue queue;
        private final boolean allowRemove;
        private IntQueueIterator iterator1;
        private IntQueueIterator iterator2;

        public IntQueueIterable(IntQueue queue) {
            this(queue, true);
        }

        public IntQueueIterable(IntQueue queue, boolean allowRemove) {
            this.queue = queue;
            this.allowRemove = allowRemove;
        }

        @Override
        public Iterator<Integer> iterator() {
            if (this.iterator1 == null) {
                this.iterator1 = new IntQueueIterator(this.queue, this.allowRemove);
                this.iterator2 = new IntQueueIterator(this.queue, this.allowRemove);
            }
            if (!this.iterator1.valid) {
                this.iterator1.index = 0;
                this.iterator1.valid = true;
                this.iterator2.valid = false;
                return this.iterator1;
            }
            this.iterator2.index = 0;
            this.iterator2.valid = true;
            this.iterator1.valid = false;
            return this.iterator2;
        }
    }

    public static class IntQueueIterator
    implements Iterator<Integer>,
    Iterable<Integer> {
        private final IntQueue queue;
        private final boolean allowRemove;
        int index;
        boolean valid = true;

        public IntQueueIterator(IntQueue queue) {
            this(queue, true);
        }

        public IntQueueIterator(IntQueue queue, boolean allowRemove) {
            this.queue = queue;
            this.allowRemove = allowRemove;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new MdxException("#iterator() cannot be used nested.");
            }
            return this.index < this.queue.size;
        }

        @Override
        public Integer next() {
            if (this.index >= this.queue.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new MdxException("#iterator() cannot be used nested.");
            }
            return this.queue.get(this.index++);
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new MdxException("Remove not allowed.");
            }
            --this.index;
            this.queue.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this;
        }
    }
}

