/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections;

import java.util.NoSuchElementException;
import org.mini2Dx.gdx.utils.IntArray;
import org.mini2Dx.gdx.utils.IntMap;

public class IntTreeMap<V>
extends IntMap<V> {
    final IntArray sortedKeys;
    private SortedKeys ascKeys1;
    private SortedKeys ascKeys2;
    private SortedKeys descKeys1;
    private SortedKeys descKeys2;

    public IntTreeMap() {
        this.sortedKeys = new IntArray();
    }

    public IntTreeMap(int initialCapacity) {
        super(initialCapacity);
        this.sortedKeys = new IntArray(initialCapacity);
    }

    public IntTreeMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.sortedKeys = new IntArray(initialCapacity);
    }

    public IntTreeMap(IntMap<? extends V> map) {
        super(map);
        this.sortedKeys = new IntArray(map.size);
    }

    public V put(int key, V value) {
        Object result = super.put(key, value);
        if (result == null) {
            this.sortedKeys.add(key);
            this.sortedKeys.sort();
        }
        return (V)result;
    }

    public void putAll(IntMap<? extends V> map) {
        super.putAll(map);
        IntMap.Keys keys = map.keys();
        keys.reset();
        while (keys.hasNext) {
            this.sortedKeys.add(keys.next());
        }
        this.sortedKeys.sort();
    }

    public V remove(int key) {
        Object result = super.remove(key);
        this.sortedKeys.removeValue(key);
        this.sortedKeys.sort();
        return (V)result;
    }

    public void clear() {
        this.sortedKeys.clear();
        super.clear();
    }

    public void clear(int maximumCapacity) {
        this.sortedKeys.clear();
        super.clear(maximumCapacity);
    }

    public IntMap.Keys ascendingKeys() {
        if (this.ascKeys1 == null) {
            this.ascKeys1 = new SortedKeys(this, true);
            this.ascKeys2 = new SortedKeys(this, true);
        }
        if (!this.ascKeys1.valid) {
            this.ascKeys1.reset();
            this.ascKeys1.valid = true;
            this.ascKeys2.valid = false;
            return this.ascKeys1;
        }
        this.ascKeys2.reset();
        this.ascKeys2.valid = true;
        this.ascKeys1.valid = false;
        return this.ascKeys2;
    }

    public IntMap.Keys descendingKeys() {
        if (this.descKeys1 == null) {
            this.descKeys1 = new SortedKeys(this, false);
            this.descKeys2 = new SortedKeys(this, false);
        }
        if (!this.descKeys1.valid) {
            this.descKeys1.reset();
            this.descKeys1.valid = true;
            this.descKeys2.valid = false;
            return this.descKeys1;
        }
        this.descKeys2.reset();
        this.descKeys2.valid = true;
        this.descKeys1.valid = false;
        return this.descKeys2;
    }

    public static class SortedKeys
    extends IntMap.Keys {
        private final IntTreeMap map;
        private boolean ascending;
        boolean valid = true;
        int index = 0;

        public SortedKeys(IntTreeMap map, boolean ascending) {
            super((IntMap)map);
            this.map = map;
            this.ascending = ascending;
            this.reset();
        }

        private void initHasNext() {
            if (this.map == null) {
                return;
            }
            this.hasNext = this.ascending ? this.index < this.map.sortedKeys.size : this.index >= 0 && this.index < this.map.sortedKeys.size;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            int result = this.map.sortedKeys.get(this.index);
            this.index = this.ascending ? ++this.index : --this.index;
            this.initHasNext();
            return result;
        }

        public void reset() {
            super.reset();
            if (this.map != null) {
                this.index = this.ascending ? 0 : this.map.sortedKeys.size - 1;
            }
            this.initHasNext();
        }
    }
}

