/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections;

import org.mini2Dx.gdx.utils.IntIntMap;
import org.mini2Dx.gdx.utils.IntMap;

public class LruIntMap<V>
extends IntMap<V> {
    public static final int DEFAULT_MAX_CAPACITY = 128;
    private final int maxCapacity;
    private final IntIntMap accessCounter = new IntIntMap();

    public LruIntMap() {
        this.maxCapacity = 128;
    }

    public LruIntMap(int initialCapacity) {
        this(initialCapacity, 128);
    }

    public LruIntMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, 128, loadFactor);
    }

    public LruIntMap(IntMap<? extends V> map) {
        this(map, 128);
    }

    public LruIntMap(int initialCapacity, int maxCapacity) {
        super(initialCapacity);
        this.maxCapacity = maxCapacity;
    }

    public LruIntMap(int initialCapacity, int maxCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.maxCapacity = maxCapacity;
    }

    public LruIntMap(IntMap<? extends V> map, int maxCapacity) {
        super(map);
        this.maxCapacity = maxCapacity;
    }

    public V put(int key, V value) {
        while (this.size >= this.maxCapacity) {
            this.purge();
        }
        Object result = super.put(key, value);
        this.accessCounter.getAndIncrement(key, -1, 1);
        return (V)result;
    }

    public void putAll(IntMap<? extends V> map) {
        while (this.size >= this.maxCapacity) {
            this.purge();
        }
        super.putAll(map);
    }

    public V get(int key) {
        Object result = super.get(key);
        this.accessCounter.getAndIncrement(key, 0, 1);
        return (V)result;
    }

    public V get(int key, V defaultValue) {
        Object result = super.get(key, defaultValue);
        this.accessCounter.getAndIncrement(key, 0, 1);
        return (V)result;
    }

    public V remove(int key) {
        Object result = super.remove(key);
        this.accessCounter.remove(key, -1);
        return (V)result;
    }

    public void clear() {
        super.clear();
        this.accessCounter.clear();
    }

    private void purge() {
        int smallestKey = 0;
        int smallestCount = Integer.MAX_VALUE;
        IntIntMap.Keys keys = this.accessCounter.keys();
        while (keys.hasNext) {
            int key = keys.next();
            int count = this.accessCounter.get(key, 0);
            if (count >= smallestCount) continue;
            smallestKey = key;
            smallestCount = count;
        }
        this.remove(smallestKey);
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }
}

