/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections;

import org.mini2Dx.gdx.utils.ObjectIntMap;
import org.mini2Dx.gdx.utils.ObjectMap;

public class LruObjectMap<K, V>
extends ObjectMap<K, V> {
    public static final int DEFAULT_MAX_CAPACITY = 128;
    private final int maxCapacity;
    private final ObjectIntMap<K> accessCounter = new ObjectIntMap();

    public LruObjectMap() {
        this.maxCapacity = 128;
    }

    public LruObjectMap(int initialCapacity) {
        this(initialCapacity, 128);
    }

    public LruObjectMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, 128, loadFactor);
    }

    public LruObjectMap(ObjectMap<? extends K, ? extends V> map) {
        this(map, 128);
    }

    public LruObjectMap(int initialCapacity, int maxCapacity) {
        super(initialCapacity);
        this.maxCapacity = maxCapacity;
    }

    public LruObjectMap(int initialCapacity, int maxCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.maxCapacity = maxCapacity;
    }

    public LruObjectMap(ObjectMap<? extends K, ? extends V> map, int maxCapacity) {
        super(map);
        this.maxCapacity = maxCapacity;
    }

    public V put(K key, V value) {
        while (this.size >= this.maxCapacity) {
            this.purge();
        }
        Object result = super.put(key, value);
        this.accessCounter.getAndIncrement(key, -1, 1);
        return (V)result;
    }

    public void putAll(ObjectMap<? extends K, ? extends V> map) {
        while (this.size >= this.maxCapacity) {
            this.purge();
        }
        super.putAll(map);
    }

    public <T extends K> V get(T key) {
        Object result = super.get(key);
        this.accessCounter.getAndIncrement(key, 0, 1);
        return (V)result;
    }

    public V get(K key, V defaultValue) {
        Object result = super.get(key, defaultValue);
        this.accessCounter.getAndIncrement(key, 0, 1);
        return (V)result;
    }

    public V remove(K key) {
        Object result = super.remove(key);
        this.accessCounter.remove(key, -1);
        return (V)result;
    }

    public void clear() {
        super.clear();
        this.accessCounter.clear();
    }

    private void purge() {
        K smallest = null;
        int smallestCount = Integer.MAX_VALUE;
        for (Object key : this.accessCounter.keys()) {
            int count = this.accessCounter.get(key, 0);
            if (count >= smallestCount) continue;
            smallest = (K)key;
            smallestCount = count;
        }
        if (smallest == null) {
            return;
        }
        this.remove(smallest);
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }
}

