/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections;

import java.util.NoSuchElementException;
import org.mini2Dx.core.collections.ShortMap;
import org.mini2Dx.gdx.utils.ShortArray;

public class ShortTreeMap<V>
extends ShortMap<V> {
    final ShortArray sortedKeys;
    private SortedKeys ascKeys1;
    private SortedKeys ascKeys2;
    private SortedKeys descKeys1;
    private SortedKeys descKeys2;

    public ShortTreeMap() {
        this.sortedKeys = new ShortArray();
    }

    public ShortTreeMap(int initialCapacity) {
        super(initialCapacity);
        this.sortedKeys = new ShortArray(initialCapacity);
    }

    public ShortTreeMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.sortedKeys = new ShortArray(initialCapacity);
    }

    public ShortTreeMap(ShortMap<? extends V> map) {
        super(map);
        this.sortedKeys = new ShortArray(map.size);
    }

    @Override
    public V put(short key, V value) {
        V result = super.put(key, value);
        if (result == null) {
            this.sortedKeys.add(key);
            this.sortedKeys.sort();
        }
        return result;
    }

    @Override
    public void putAll(ShortMap<V> map) {
        super.putAll(map);
        ShortMap.Keys keys = map.keys();
        keys.reset();
        while (keys.hasNext) {
            this.sortedKeys.add(keys.next());
        }
        this.sortedKeys.sort();
    }

    @Override
    public V remove(short key) {
        Object result = super.remove(key);
        this.sortedKeys.removeValue(key);
        this.sortedKeys.sort();
        return result;
    }

    @Override
    public void clear() {
        this.sortedKeys.clear();
        super.clear();
    }

    @Override
    public void clear(int maximumCapacity) {
        this.sortedKeys.clear();
        super.clear(maximumCapacity);
    }

    public ShortMap.Keys ascendingKeys() {
        if (this.ascKeys1 == null) {
            this.ascKeys1 = new SortedKeys(this, true);
            this.ascKeys2 = new SortedKeys(this, true);
        }
        if (!this.ascKeys1.valid) {
            this.ascKeys1.reset();
            this.ascKeys1.valid = true;
            this.ascKeys2.valid = false;
            return this.ascKeys1;
        }
        this.ascKeys2.reset();
        this.ascKeys2.valid = true;
        this.ascKeys1.valid = false;
        return this.ascKeys2;
    }

    public ShortMap.Keys descendingKeys() {
        if (this.descKeys1 == null) {
            this.descKeys1 = new SortedKeys(this, false);
            this.descKeys2 = new SortedKeys(this, false);
        }
        if (!this.descKeys1.valid) {
            this.descKeys1.reset();
            this.descKeys1.valid = true;
            this.descKeys2.valid = false;
            return this.descKeys1;
        }
        this.descKeys2.reset();
        this.descKeys2.valid = true;
        this.descKeys1.valid = false;
        return this.descKeys2;
    }

    public static class SortedKeys
    extends ShortMap.Keys {
        private final ShortTreeMap map;
        private boolean ascending;
        boolean valid = true;
        int index = 0;

        public SortedKeys(ShortTreeMap map, boolean ascending) {
            super((ShortMap)map);
            this.map = map;
            this.ascending = ascending;
            this.reset();
        }

        private void initHasNext() {
            if (this.map == null) {
                return;
            }
            this.hasNext = this.ascending ? this.index < this.map.sortedKeys.size : this.index >= 0 && this.index < this.map.sortedKeys.size;
        }

        @Override
        public short next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            short result = this.map.sortedKeys.get(this.index);
            this.index = this.ascending ? ++this.index : --this.index;
            this.initHasNext();
            return result;
        }

        @Override
        public void reset() {
            super.reset();
            if (this.map != null) {
                this.index = this.ascending ? 0 : this.map.sortedKeys.size - 1;
            }
            this.initHasNext();
        }
    }
}

