/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import java.util.Comparator;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Predicate;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentArray<T>
extends Array<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentArray() {
    }

    public ConcurrentArray(int capacity) {
        super(capacity);
    }

    public ConcurrentArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public ConcurrentArray(boolean ordered, int capacity, Class arrayType) {
        super(ordered, capacity, arrayType);
    }

    public ConcurrentArray(Class arrayType) {
        super(arrayType);
    }

    public ConcurrentArray(Array<? extends T> array) {
        super(array);
    }

    public ConcurrentArray(T[] array) {
        super((Object[])array);
    }

    public ConcurrentArray(boolean ordered, T[] array, int start, int count) {
        super(ordered, (Object[])array, start, count);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void add(T value) {
        this.lock.lockWrite();
        super.add(value);
        this.lock.unlockWrite();
    }

    public void add(T value1, T value2) {
        this.lock.lockWrite();
        super.add(value1, value2);
        this.lock.unlockWrite();
    }

    public void add(T value1, T value2, T value3) {
        this.lock.lockWrite();
        super.add(value1, value2, value3);
        this.lock.unlockWrite();
    }

    public void add(T value1, T value2, T value3, T value4) {
        this.lock.lockWrite();
        super.add(value1, value2, value3, value4);
        this.lock.unlockWrite();
    }

    public void addAll(Array<? extends T> array, int start, int count) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(array, start, count);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
    }

    public void addAll(T[] array, int start, int count) {
        this.lock.lockWrite();
        super.addAll((Object[])array, start, count);
        this.lock.unlockWrite();
    }

    public T get(int index) {
        this.lock.lockRead();
        Object elem = super.get(index);
        this.lock.unlockRead();
        return (T)elem;
    }

    public void set(int index, T value) {
        this.lock.lockWrite();
        super.set(index, value);
        this.lock.unlockWrite();
    }

    public void insert(int index, T value) {
        this.lock.lockWrite();
        super.insert(index, value);
        this.lock.unlockWrite();
    }

    public void swap(int first, int second) {
        this.lock.lockWrite();
        super.swap(first, second);
        this.lock.unlockWrite();
    }

    public boolean contains(T value, boolean identity) {
        this.lock.lockRead();
        boolean cont = super.contains(value, identity);
        this.lock.unlockRead();
        return cont;
    }

    public boolean containsAll(Array<? extends T> values, boolean identity) {
        boolean isOtherConcurrent = values instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)values).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.containsAll(values, identity);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)values).getLock().unlockRead();
        }
        return b;
    }

    public boolean containsAny(Array<? extends T> values, boolean identity) {
        boolean isOtherConcurrent = values instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)values).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.containsAny(values, identity);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)values).getLock().unlockRead();
        }
        return b;
    }

    public boolean removeValue(T value, boolean identity) {
        this.lock.lockWrite();
        boolean b = super.removeValue(value, identity);
        this.lock.unlockWrite();
        return b;
    }

    public boolean removeAll(Array<? extends T> array, boolean identity) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        boolean b = super.removeAll(array, identity);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
        return b;
    }

    public T selectRanked(Comparator<T> comparator, int kthLowest) {
        this.lock.lockRead();
        Object e = super.selectRanked(comparator, kthLowest);
        this.lock.unlockRead();
        return (T)e;
    }

    public int selectRankedIndex(Comparator<T> comparator, int kthLowest) {
        this.lock.lockRead();
        int i = super.selectRankedIndex(comparator, kthLowest);
        this.lock.unlockRead();
        return i;
    }

    public Iterable<T> select(Predicate<T> predicate) {
        this.lock.lockRead();
        Iterable iT = super.select(predicate);
        this.lock.unlockRead();
        return iT;
    }

    public int indexOf(T value, boolean identity) {
        this.lock.lockRead();
        int idx = super.indexOf(value, identity);
        this.lock.unlockRead();
        return idx;
    }

    public int lastIndexOf(T value, boolean identity) {
        this.lock.lockRead();
        int idx = super.lastIndexOf(value, identity);
        this.lock.unlockRead();
        return idx;
    }

    public T removeIndex(int index) {
        this.lock.lockWrite();
        Object elem = super.removeIndex(index);
        this.lock.unlockWrite();
        return (T)elem;
    }

    public void removeRange(int start, int end) {
        this.lock.lockWrite();
        super.removeRange(start, end);
        this.lock.unlockWrite();
    }

    public T pop() {
        this.lock.lockWrite();
        Object elem = super.pop();
        this.lock.unlockWrite();
        return (T)elem;
    }

    public T peek() {
        this.lock.lockRead();
        Object elem = super.peek();
        this.lock.unlockRead();
        return (T)elem;
    }

    public T first() {
        this.lock.lockRead();
        Object elem = super.first();
        this.lock.unlockRead();
        return (T)elem;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean notE = super.notEmpty();
        this.lock.unlockRead();
        return notE;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean isE = super.isEmpty();
        this.lock.unlockRead();
        return isE;
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public Array.ArrayIterator<T> iterator() {
        return new Array.ArrayIterator((Array)this);
    }

    public T[] shrink() {
        this.lock.lockWrite();
        Object[] elems = super.shrink();
        this.lock.unlockWrite();
        return elems;
    }

    public T[] ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        Object[] elems = super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
        return elems;
    }

    public T[] setSize(int newSize) {
        this.lock.lockWrite();
        Object[] elems = super.setSize(newSize);
        this.lock.unlockWrite();
        return elems;
    }

    public void reverse() {
        this.lock.lockWrite();
        super.reverse();
        this.lock.unlockWrite();
    }

    public void shuffle() {
        this.lock.lockWrite();
        super.shuffle();
        this.lock.unlockWrite();
    }

    public void truncate(int newSize) {
        this.lock.lockWrite();
        super.truncate(newSize);
        this.lock.unlockWrite();
    }

    public T random() {
        this.lock.lockRead();
        Object elem = super.random();
        this.lock.unlockRead();
        return (T)elem;
    }

    public T[] toArray() {
        this.lock.lockRead();
        Object[] elems = super.toArray();
        this.lock.unlockRead();
        return elems;
    }

    public <V> V[] toArray(Class<V> type) {
        this.lock.lockRead();
        Object[] elems = super.toArray(type);
        this.lock.unlockRead();
        return elems;
    }

    public int hashCode() {
        this.lock.lockRead();
        int hc = super.hashCode();
        this.lock.unlockRead();
        return hc;
    }

    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean e = super.equals(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return e;
    }

    public boolean equalsIdentity(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean e = super.equalsIdentity(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return e;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

