/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.ArrayMap;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentArrayMap<K, V>
extends ArrayMap<K, V>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentArrayMap() {
    }

    public ConcurrentArrayMap(int capacity) {
        super(capacity);
    }

    public ConcurrentArrayMap(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public ConcurrentArrayMap(boolean ordered, int capacity, Class keyArrayType, Class valueArrayType) {
        super(ordered, capacity, keyArrayType, valueArrayType);
    }

    public ConcurrentArrayMap(Class keyArrayType, Class valueArrayType) {
        super(keyArrayType, valueArrayType);
    }

    public ConcurrentArrayMap(ArrayMap array) {
        super(array);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public int put(K key, V value) {
        this.lock.lockWrite();
        int i = super.put(key, value);
        this.lock.unlockWrite();
        return i;
    }

    public int put(K key, V value, int index) {
        this.lock.lockWrite();
        int i = super.put(key, value, index);
        this.lock.unlockWrite();
        return i;
    }

    public void putAll(ArrayMap<? extends K, ? extends V> map, int offset, int length) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map, offset, length);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().unlockRead();
        }
    }

    public V get(K key) {
        this.lock.lockRead();
        Object value = super.get(key);
        this.lock.unlockRead();
        return (V)value;
    }

    public V get(K key, V defaultValue) {
        this.lock.lockRead();
        Object value = super.get(key, defaultValue);
        this.lock.unlockRead();
        return (V)value;
    }

    public K getKey(V value, boolean identity) {
        this.lock.lockRead();
        Object key = super.getKey(value, identity);
        this.lock.unlockRead();
        return (K)key;
    }

    public K getKeyAt(int index) {
        this.lock.lockRead();
        Object key = super.getKeyAt(index);
        this.lock.unlockRead();
        return (K)key;
    }

    public V getValueAt(int index) {
        this.lock.lockRead();
        Object value = super.getValueAt(index);
        this.lock.unlockRead();
        return (V)value;
    }

    public K firstKey() {
        this.lock.lockRead();
        Object key = super.firstKey();
        this.lock.unlockRead();
        return (K)key;
    }

    public V firstValue() {
        this.lock.lockRead();
        Object value = super.firstValue();
        this.lock.unlockRead();
        return (V)value;
    }

    public void setKey(int index, K key) {
        this.lock.lockWrite();
        super.setKey(index, key);
        this.lock.unlockWrite();
    }

    public void setValue(int index, V value) {
        this.lock.lockWrite();
        super.setValue(index, value);
        this.lock.unlockWrite();
    }

    public void insert(int index, K key, V value) {
        this.lock.lockWrite();
        super.insert(index, key, value);
        this.lock.unlockWrite();
    }

    public boolean containsKey(K key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsValue(V value, boolean identity) {
        this.lock.lockRead();
        boolean b = super.containsValue(value, identity);
        this.lock.unlockRead();
        return b;
    }

    public int indexOfKey(K key) {
        this.lock.lockRead();
        int i = super.indexOfKey(key);
        this.lock.unlockRead();
        return i;
    }

    public int indexOfValue(V value, boolean identity) {
        this.lock.lockRead();
        int i = super.indexOfValue(value, identity);
        this.lock.unlockRead();
        return i;
    }

    public void removeIndex(int index) {
        this.lock.lockWrite();
        super.removeIndex(index);
        this.lock.unlockWrite();
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public K peekKey() {
        this.lock.lockRead();
        Object key = super.peekKey();
        this.lock.unlockRead();
        return (K)key;
    }

    public V peekValue() {
        this.lock.lockRead();
        Object value = super.peekValue();
        this.lock.unlockRead();
        return (V)value;
    }

    public void clear(int maximumCapacity) {
        if (this.keys.length <= maximumCapacity) {
            this.clear();
            return;
        }
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public void shrink() {
        this.lock.lockWrite();
        super.shrink();
        this.lock.unlockWrite();
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public void reverse() {
        this.lock.lockWrite();
        super.reverse();
        this.lock.unlockWrite();
    }

    public void shuffle() {
        this.lock.lockWrite();
        super.shuffle();
        this.lock.unlockWrite();
    }

    public void truncate(int newSize) {
        this.lock.lockWrite();
        super.truncate(newSize);
        this.lock.unlockWrite();
    }

    public V removeKey(K key) {
        this.lock.lockWrite();
        Object v = super.removeKey(key);
        this.lock.unlockWrite();
        return (V)v;
    }

    public boolean removeValue(V value, boolean identity) {
        this.lock.lockWrite();
        boolean b = super.removeValue(value, identity);
        this.lock.unlockWrite();
        return b;
    }

    public int hashCode() {
        this.lock.lockRead();
        int hc = super.hashCode();
        this.lock.unlockRead();
        return hc;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean e = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return e;
    }

    public boolean equalsIdentity(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean e = super.equalsIdentity(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return e;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public ArrayMap.Entries<K, V> entries() {
        this.lock.lockRead();
        ArrayMap.Entries e = super.entries();
        this.lock.unlockRead();
        return e;
    }

    public ArrayMap.Values<V> values() {
        this.lock.lockRead();
        ArrayMap.Values v = super.values();
        this.lock.unlockRead();
        return v;
    }

    public ArrayMap.Keys<K> keys() {
        this.lock.lockRead();
        ArrayMap.Keys k = super.keys();
        this.lock.unlockRead();
        return k;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

