/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.Bits;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentBits
extends Bits
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentBits() {
    }

    public ConcurrentBits(int nbits) {
        super(nbits);
    }

    public boolean get(int index) {
        this.lock.lockRead();
        boolean b = super.get(index);
        this.lock.unlockRead();
        return b;
    }

    public boolean getAndClear(int index) {
        this.lock.lockWrite();
        boolean b = super.getAndClear(index);
        this.lock.unlockWrite();
        return b;
    }

    public boolean getAndSet(int index) {
        this.lock.lockWrite();
        boolean b = super.getAndSet(index);
        this.lock.unlockWrite();
        return b;
    }

    public void set(int index) {
        this.lock.lockWrite();
        super.set(index);
        this.lock.unlockWrite();
    }

    public void flip(int index) {
        this.lock.lockWrite();
        super.flip(index);
        this.lock.unlockWrite();
    }

    public void clear(int index) {
        this.lock.lockWrite();
        super.clear(index);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public int numBits() {
        this.lock.lockRead();
        int n = super.numBits();
        this.lock.unlockRead();
        return n;
    }

    public int length() {
        this.lock.lockRead();
        int l = super.length();
        this.lock.unlockRead();
        return l;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public int nextSetBit(int fromIndex) {
        this.lock.unlockRead();
        int i = super.nextSetBit(fromIndex);
        this.lock.unlockRead();
        return i;
    }

    public int nextClearBit(int fromIndex) {
        this.lock.lockRead();
        int i = super.nextClearBit(fromIndex);
        this.lock.unlockRead();
        return i;
    }

    public void and(Bits other) {
        boolean isOtherConcurrent = other instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.and(other);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().unlockRead();
        }
    }

    public void andNot(Bits other) {
        boolean isOtherConcurrent = other instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.andNot(other);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().unlockRead();
        }
    }

    public void or(Bits other) {
        boolean isOtherConcurrent = other instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.or(other);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().unlockRead();
        }
    }

    public void xor(Bits other) {
        boolean isOtherConcurrent = other instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.xor(other);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().unlockRead();
        }
    }

    public boolean intersects(Bits other) {
        boolean isOtherConcurrent = other instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.intersects(other);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().unlockRead();
        }
        return b;
    }

    public boolean containsAll(Bits other) {
        boolean isOtherConcurrent = other instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.containsAll(other);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)other).getLock().unlockRead();
        }
        return b;
    }

    public int hashCode() {
        this.lock.lockRead();
        int hc = super.hashCode();
        this.lock.unlockRead();
        return hc;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

