/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.BooleanArray;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentBooleanArray
extends BooleanArray
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentBooleanArray() {
    }

    public ConcurrentBooleanArray(int capacity) {
        super(capacity);
    }

    public ConcurrentBooleanArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public ConcurrentBooleanArray(BooleanArray array) {
        super(array);
    }

    public ConcurrentBooleanArray(boolean[] array) {
        super(array);
    }

    public ConcurrentBooleanArray(boolean ordered, boolean[] array, int startIndex, int count) {
        super(ordered, array, startIndex, count);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void add(boolean value) {
        this.lock.lockWrite();
        super.add(value);
        this.lock.unlockWrite();
    }

    public void add(boolean value1, boolean value2) {
        this.lock.lockWrite();
        super.add(value1, value2);
        this.lock.unlockWrite();
    }

    public void add(boolean value1, boolean value2, boolean value3) {
        this.lock.lockWrite();
        super.add(value1, value2, value3);
        this.lock.unlockWrite();
    }

    public void add(boolean value1, boolean value2, boolean value3, boolean value4) {
        this.lock.lockWrite();
        super.add(value1, value2, value3, value4);
        this.lock.unlockWrite();
    }

    public void addAll(boolean[] array, int offset, int length) {
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
    }

    public boolean get(int index) {
        this.lock.lockRead();
        boolean b = super.get(index);
        this.lock.unlockRead();
        return b;
    }

    public void set(int index, boolean value) {
        this.lock.lockWrite();
        super.set(index, value);
        this.lock.unlockWrite();
    }

    public void insert(int index, boolean value) {
        this.lock.lockWrite();
        super.insert(index, value);
        this.lock.unlockWrite();
    }

    public void swap(int first, int second) {
        this.lock.lockWrite();
        super.swap(first, second);
        this.lock.unlockWrite();
    }

    public boolean removeIndex(int index) {
        this.lock.lockWrite();
        boolean b = super.removeIndex(index);
        this.lock.unlockWrite();
        return b;
    }

    public void removeRange(int start, int end) {
        this.lock.lockWrite();
        super.removeRange(start, end);
        this.lock.unlockWrite();
    }

    public boolean pop() {
        this.lock.lockWrite();
        boolean b = super.pop();
        this.lock.unlockWrite();
        return b;
    }

    public boolean peek() {
        this.lock.lockRead();
        boolean b = super.peek();
        this.lock.unlockRead();
        return b;
    }

    public boolean first() {
        this.lock.lockRead();
        boolean b = super.first();
        this.lock.unlockRead();
        return b;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean[] shrink() {
        this.lock.lockWrite();
        boolean[] b = super.shrink();
        this.lock.unlockWrite();
        return b;
    }

    public boolean[] ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        boolean[] b = super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
        return b;
    }

    public boolean[] setSize(int newSize) {
        this.lock.lockWrite();
        boolean[] b = super.setSize(newSize);
        this.lock.unlockWrite();
        return b;
    }

    public void reverse() {
        this.lock.lockWrite();
        super.reverse();
        this.lock.unlockWrite();
    }

    public void shuffle() {
        this.lock.lockWrite();
        super.shuffle();
        this.lock.unlockWrite();
    }

    public void truncate(int newSize) {
        this.lock.lockWrite();
        super.truncate(newSize);
        this.lock.unlockWrite();
    }

    public boolean random() {
        this.lock.lockRead();
        boolean b = super.random();
        this.lock.unlockRead();
        return b;
    }

    public void addAll(BooleanArray array, int offset, int length) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
    }

    public boolean removeAll(BooleanArray array) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        boolean b = super.removeAll(array);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
        return b;
    }

    public boolean[] toArray() {
        this.lock.lockRead();
        boolean[] b = super.toArray();
        this.lock.unlockRead();
        return b;
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

