/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import java.util.Iterator;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.BooleanQueue;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentBooleanQueue
extends BooleanQueue
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentBooleanQueue() {
    }

    public ConcurrentBooleanQueue(int initialSize) {
        super(initialSize);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    @Override
    public void addLast(boolean object) {
        this.lock.lockWrite();
        super.addLast(object);
        this.lock.unlockWrite();
    }

    @Override
    public void addFirst(boolean object) {
        this.lock.lockWrite();
        super.addFirst(object);
        this.lock.unlockWrite();
    }

    @Override
    public void ensureCapacity(int additional) {
        this.lock.lockWrite();
        super.ensureCapacity(additional);
        this.lock.unlockWrite();
    }

    @Override
    public boolean removeFirst() {
        this.lock.lockWrite();
        boolean b = super.removeFirst();
        this.lock.unlockWrite();
        return b;
    }

    @Override
    public boolean removeLast() {
        this.lock.lockWrite();
        boolean b = super.removeLast();
        this.lock.unlockWrite();
        return b;
    }

    @Override
    public int indexOf(boolean value) {
        this.lock.lockRead();
        int i = super.indexOf(value);
        this.lock.unlockRead();
        return i;
    }

    @Override
    public boolean removeValue(boolean value) {
        this.lock.lockWrite();
        boolean b = super.removeValue(value);
        this.lock.unlockWrite();
        return b;
    }

    @Override
    public boolean removeIndex(int index) {
        this.lock.lockWrite();
        boolean b = super.removeIndex(index);
        this.lock.unlockWrite();
        return b;
    }

    @Override
    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    @Override
    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    @Override
    public boolean first() {
        this.lock.lockRead();
        boolean b = super.first();
        this.lock.unlockRead();
        return b;
    }

    @Override
    public boolean last() {
        this.lock.lockRead();
        boolean b = super.last();
        this.lock.unlockRead();
        return b;
    }

    @Override
    public boolean get(int index) {
        this.lock.lockRead();
        boolean b = super.get(index);
        this.lock.unlockRead();
        return b;
    }

    @Override
    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new BooleanQueue.BooleanQueueIterator(this);
    }

    @Override
    public int hashCode() {
        this.lock.lockRead();
        int hc = super.hashCode();
        this.lock.unlockRead();
        return hc;
    }

    @Override
    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean e = super.equals(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return e;
    }

    @Override
    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    @Override
    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

