/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.ByteArray;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentByteArray
extends ByteArray
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentByteArray() {
    }

    public ConcurrentByteArray(int capacity) {
        super(capacity);
    }

    public ConcurrentByteArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public ConcurrentByteArray(ByteArray array) {
        super(array);
    }

    public ConcurrentByteArray(byte[] array) {
        super(array);
    }

    public ConcurrentByteArray(boolean ordered, byte[] array, int startIndex, int count) {
        super(ordered, array, startIndex, count);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void add(byte value) {
        this.lock.lockWrite();
        super.add(value);
        this.lock.unlockWrite();
    }

    public void add(byte value1, byte value2) {
        this.lock.lockWrite();
        super.add(value1, value2);
        this.lock.unlockWrite();
    }

    public void add(byte value1, byte value2, byte value3) {
        this.lock.lockWrite();
        super.add(value1, value2, value3);
        this.lock.unlockWrite();
    }

    public void add(byte value1, byte value2, byte value3, byte value4) {
        this.lock.lockWrite();
        super.add(value1, value2, value3, value4);
        this.lock.unlockWrite();
    }

    public void addAll(byte[] array, int offset, int length) {
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
    }

    public byte get(int index) {
        this.lock.lockRead();
        byte b = super.get(index);
        this.lock.unlockRead();
        return b;
    }

    public void set(int index, byte value) {
        this.lock.lockWrite();
        super.set(index, value);
        this.lock.unlockWrite();
    }

    public void insert(int index, byte value) {
        this.lock.lockWrite();
        super.insert(index, value);
        this.lock.unlockWrite();
    }

    public void swap(int first, int second) {
        this.lock.lockWrite();
        super.swap(first, second);
        this.lock.unlockWrite();
    }

    public void addAll(ByteArray array, int offset, int length) {
        boolean otherIsConcurrent = array instanceof ConcurrentCollection;
        if (otherIsConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
        if (otherIsConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
    }

    public int removeIndex(int index) {
        this.lock.lockWrite();
        int i = super.removeIndex(index);
        this.lock.unlockWrite();
        return i;
    }

    public void removeRange(int start, int end) {
        this.lock.lockWrite();
        super.removeRange(start, end);
        this.lock.unlockWrite();
    }

    public byte pop() {
        this.lock.lockWrite();
        byte b = super.pop();
        this.lock.unlockWrite();
        return b;
    }

    public byte peek() {
        this.lock.lockRead();
        byte b = super.peek();
        this.lock.unlockRead();
        return b;
    }

    public byte first() {
        this.lock.lockRead();
        byte b = super.first();
        this.lock.unlockRead();
        return b;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public byte[] shrink() {
        this.lock.lockWrite();
        byte[] b = super.shrink();
        this.lock.unlockWrite();
        return b;
    }

    public void incr(int index, byte value) {
        this.lock.lockWrite();
        super.incr(index, value);
        this.lock.unlockWrite();
    }

    public void mul(int index, byte value) {
        this.lock.lockWrite();
        super.mul(index, value);
        this.lock.unlockWrite();
    }

    public boolean contains(byte value) {
        this.lock.lockRead();
        boolean b = super.contains(value);
        this.lock.unlockRead();
        return b;
    }

    public int indexOf(byte value) {
        this.lock.lockRead();
        int i = super.indexOf(value);
        this.lock.unlockRead();
        return i;
    }

    public int lastIndexOf(byte value) {
        this.lock.lockRead();
        int i = super.lastIndexOf(value);
        this.lock.unlockRead();
        return i;
    }

    public boolean removeValue(byte value) {
        this.lock.lockWrite();
        boolean b = super.removeValue(value);
        this.lock.unlockWrite();
        return b;
    }

    public boolean removeAll(ByteArray array) {
        boolean otherIsConcurrent = array instanceof ConcurrentCollection;
        if (otherIsConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        boolean b = super.removeAll(array);
        this.lock.unlockWrite();
        if (otherIsConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
        return b;
    }

    public void sort() {
        this.lock.lockWrite();
        super.sort();
        this.lock.unlockWrite();
    }

    public byte[] ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        byte[] b = super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
        return b;
    }

    public byte[] setSize(int newSize) {
        this.lock.lockWrite();
        byte[] b = super.setSize(newSize);
        this.lock.unlockWrite();
        return b;
    }

    public void reverse() {
        this.lock.lockWrite();
        super.reverse();
        this.lock.unlockWrite();
    }

    public void shuffle() {
        this.lock.lockWrite();
        super.shuffle();
        this.lock.unlockWrite();
    }

    public void truncate(int newSize) {
        this.lock.lockWrite();
        super.truncate(newSize);
        this.lock.unlockWrite();
    }

    public byte random() {
        this.lock.lockRead();
        byte b = super.random();
        this.lock.unlockRead();
        return b;
    }

    public byte[] toArray() {
        this.lock.lockRead();
        byte[] b = super.toArray();
        this.lock.unlockRead();
        return b;
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

