/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import java.util.Comparator;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.DelayedRemovalArray;
import org.mini2Dx.gdx.utils.Predicate;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentDelayedRemovalArray<T>
extends DelayedRemovalArray<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentDelayedRemovalArray() {
    }

    public ConcurrentDelayedRemovalArray(Array<? extends T> array) {
        super(array);
    }

    public ConcurrentDelayedRemovalArray(boolean ordered, int capacity, Class arrayType) {
        super(ordered, capacity, arrayType);
    }

    public ConcurrentDelayedRemovalArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public ConcurrentDelayedRemovalArray(boolean ordered, T[] array, int startIndex, int count) {
        super(ordered, (Object[])array, startIndex, count);
    }

    public ConcurrentDelayedRemovalArray(Class arrayType) {
        super(arrayType);
    }

    public ConcurrentDelayedRemovalArray(int capacity) {
        super(capacity);
    }

    public ConcurrentDelayedRemovalArray(T[] array) {
        super((Object[])array);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void begin() {
        this.lock.lockWrite();
        super.begin();
        this.lock.unlockWrite();
    }

    public void end() {
        this.lock.lockWrite();
        super.end();
        this.lock.unlockWrite();
    }

    public boolean removeValue(T value, boolean identity) {
        this.lock.lockWrite();
        boolean b = super.removeValue(value, identity);
        this.lock.unlockWrite();
        return b;
    }

    public T removeIndex(int index) {
        this.lock.lockWrite();
        Object t = super.removeIndex(index);
        this.lock.unlockWrite();
        return (T)t;
    }

    public void removeRange(int start, int end) {
        this.lock.lockWrite();
        super.removeRange(start, end);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public void set(int index, T value) {
        this.lock.lockWrite();
        super.set(index, value);
        this.lock.unlockWrite();
    }

    public void insert(int index, T value) {
        this.lock.lockWrite();
        super.insert(index, value);
        this.lock.unlockWrite();
    }

    public void swap(int first, int second) {
        this.lock.lockWrite();
        super.swap(first, second);
        this.lock.unlockWrite();
    }

    public T pop() {
        this.lock.lockWrite();
        Object t = super.pop();
        this.lock.unlockWrite();
        return (T)t;
    }

    public void sort() {
        this.lock.lockWrite();
        super.sort();
        this.lock.unlockWrite();
    }

    public void sort(Comparator<? super T> comparator) {
        this.lock.lockWrite();
        super.sort(comparator);
        this.lock.unlockWrite();
    }

    public void reverse() {
        this.lock.lockWrite();
        super.reverse();
        this.lock.unlockWrite();
    }

    public void shuffle() {
        this.lock.lockWrite();
        super.shuffle();
        this.lock.unlockWrite();
    }

    public void truncate(int newSize) {
        this.lock.lockWrite();
        super.truncate(newSize);
        this.lock.unlockWrite();
    }

    public T[] setSize(int newSize) {
        this.lock.lockWrite();
        Object[] t = super.setSize(newSize);
        this.lock.unlockWrite();
        return t;
    }

    public void add(T value) {
        this.lock.lockWrite();
        super.add(value);
        this.lock.unlockWrite();
    }

    public void add(T value1, T value2) {
        this.lock.lockWrite();
        super.add(value1, value2);
        this.lock.unlockWrite();
    }

    public void add(T value1, T value2, T value3) {
        this.lock.lockWrite();
        super.add(value1, value2, value3);
        this.lock.unlockWrite();
    }

    public void add(T value1, T value2, T value3, T value4) {
        this.lock.lockWrite();
        super.add(value1, value2, value3, value4);
        this.lock.unlockWrite();
    }

    public void addAll(Array<? extends T> array, int start, int count) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(array, start, count);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
    }

    public void addAll(T[] array, int start, int count) {
        this.lock.lockWrite();
        super.addAll((Object[])array, start, count);
        this.lock.unlockWrite();
    }

    public T get(int index) {
        this.lock.lockRead();
        Object t = super.get(index);
        this.lock.unlockRead();
        return (T)t;
    }

    public boolean contains(T value, boolean identity) {
        this.lock.lockRead();
        boolean b = super.contains(value, identity);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsAll(Array<? extends T> values, boolean identity) {
        this.lock.lockRead();
        boolean b = super.containsAll(values, identity);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsAny(Array<? extends T> values, boolean identity) {
        this.lock.lockRead();
        boolean b = super.containsAny(values, identity);
        this.lock.unlockRead();
        return b;
    }

    public int indexOf(T value, boolean identity) {
        this.lock.lockRead();
        int i = super.indexOf(value, identity);
        this.lock.unlockRead();
        return i;
    }

    public int lastIndexOf(T value, boolean identity) {
        this.lock.lockRead();
        int i = super.lastIndexOf(value, identity);
        this.lock.unlockRead();
        return i;
    }

    public boolean removeAll(Array<? extends T> array, boolean identity) {
        this.lock.lockWrite();
        boolean b = super.removeAll(array, identity);
        this.lock.unlockWrite();
        return b;
    }

    public T peek() {
        this.lock.lockRead();
        Object t = super.peek();
        this.lock.unlockRead();
        return (T)t;
    }

    public T first() {
        this.lock.lockRead();
        Object t = super.first();
        this.lock.unlockRead();
        return (T)t;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public T[] shrink() {
        this.lock.lockWrite();
        Object[] t = super.shrink();
        this.lock.unlockWrite();
        return t;
    }

    public T[] ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        Object[] t = super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
        return t;
    }

    public T selectRanked(Comparator<T> comparator, int kthLowest) {
        this.lock.lockRead();
        Object t = super.selectRanked(comparator, kthLowest);
        this.lock.unlockRead();
        return (T)t;
    }

    public int selectRankedIndex(Comparator<T> comparator, int kthLowest) {
        this.lock.lockRead();
        int i = super.selectRankedIndex(comparator, kthLowest);
        this.lock.unlockRead();
        return i;
    }

    public Array.ArrayIterator<T> iterator() {
        return new Array.ArrayIterator((Array)this);
    }

    public Iterable<T> select(Predicate<T> predicate) {
        this.lock.lockRead();
        Iterable iT = super.select(predicate);
        this.lock.unlockRead();
        return iT;
    }

    public T random() {
        this.lock.lockRead();
        Object t = super.random();
        this.lock.unlockRead();
        return (T)t;
    }

    public T[] toArray() {
        this.lock.lockRead();
        Object[] t = super.toArray();
        this.lock.unlockRead();
        return t;
    }

    public <V> V[] toArray(Class<V> type) {
        this.lock.lockRead();
        Object[] v = super.toArray(type);
        this.lock.unlockRead();
        return v;
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentDelayedRemovalArray;
        if (isOtherConcurrent) {
            ((ConcurrentDelayedRemovalArray)object).lock.lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentDelayedRemovalArray)object).lock.unlockRead();
        }
        return b;
    }

    public boolean equalsIdentity(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentDelayedRemovalArray;
        if (isOtherConcurrent) {
            ((ConcurrentDelayedRemovalArray)object).lock.lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equalsIdentity(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentDelayedRemovalArray)object).lock.unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

