/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.FloatArray;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentFloatArray
extends FloatArray
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentFloatArray() {
    }

    public ConcurrentFloatArray(int capacity) {
        super(capacity);
    }

    public ConcurrentFloatArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public ConcurrentFloatArray(FloatArray array) {
        super(array);
    }

    public ConcurrentFloatArray(float[] array) {
        super(array);
    }

    public ConcurrentFloatArray(boolean ordered, float[] array, int startIndex, int count) {
        super(ordered, array, startIndex, count);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void add(float value) {
        this.lock.lockWrite();
        super.add(value);
        this.lock.unlockWrite();
    }

    public void add(float value1, float value2) {
        this.lock.lockWrite();
        super.add(value1, value2);
        this.lock.unlockWrite();
    }

    public void add(float value1, float value2, float value3) {
        this.lock.lockWrite();
        super.add(value1, value2, value3);
        this.lock.unlockWrite();
    }

    public void add(float value1, float value2, float value3, float value4) {
        this.lock.lockWrite();
        super.add(value1, value2, value3, value4);
        this.lock.unlockWrite();
    }

    public void addAll(FloatArray array, int offset, int length) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
    }

    public void addAll(float[] array, int offset, int length) {
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
    }

    public float get(int index) {
        this.lock.lockRead();
        float f = super.get(index);
        this.lock.unlockRead();
        return f;
    }

    public void set(int index, float value) {
        this.lock.lockWrite();
        super.set(index, value);
        this.lock.unlockWrite();
    }

    public void incr(int index, float value) {
        this.lock.lockWrite();
        super.incr(index, value);
        this.lock.unlockWrite();
    }

    public void mul(int index, float value) {
        this.lock.lockWrite();
        super.mul(index, value);
        this.lock.unlockWrite();
    }

    public void insert(int index, float value) {
        this.lock.lockWrite();
        super.insert(index, value);
        this.lock.unlockWrite();
    }

    public void swap(int first, int second) {
        this.lock.lockWrite();
        super.swap(first, second);
        this.lock.unlockWrite();
    }

    public boolean contains(float value) {
        this.lock.lockRead();
        boolean b = super.contains(value);
        this.lock.unlockRead();
        return b;
    }

    public int indexOf(float value) {
        this.lock.lockRead();
        int i = super.indexOf(value);
        this.lock.unlockRead();
        return i;
    }

    public int lastIndexOf(float value) {
        this.lock.lockRead();
        int i = super.lastIndexOf(value);
        this.lock.unlockRead();
        return i;
    }

    public boolean removeValue(float value) {
        this.lock.lockWrite();
        boolean b = super.removeValue(value);
        this.lock.unlockWrite();
        return b;
    }

    public float removeIndex(int index) {
        this.lock.lockWrite();
        float f = super.removeIndex(index);
        this.lock.unlockWrite();
        return f;
    }

    public void removeRange(int start, int end) {
        this.lock.lockWrite();
        super.removeRange(start, end);
        this.lock.unlockWrite();
    }

    public boolean removeAll(FloatArray array) {
        this.lock.lockWrite();
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        boolean b = super.removeAll(array);
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
        this.lock.lockWrite();
        return b;
    }

    public float pop() {
        this.lock.lockWrite();
        float f = super.pop();
        this.lock.unlockWrite();
        return f;
    }

    public float peek() {
        this.lock.lockRead();
        float f = super.peek();
        this.lock.unlockRead();
        return f;
    }

    public float first() {
        this.lock.lockRead();
        float f = super.first();
        this.lock.unlockRead();
        return f;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public float[] shrink() {
        this.lock.lockWrite();
        float[] f = super.shrink();
        this.lock.unlockWrite();
        return f;
    }

    public float[] ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        float[] f = super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
        return f;
    }

    public float[] setSize(int newSize) {
        this.lock.lockWrite();
        float[] f = super.setSize(newSize);
        this.lock.unlockWrite();
        return f;
    }

    public void sort() {
        this.lock.lockWrite();
        super.sort();
        this.lock.unlockWrite();
    }

    public void reverse() {
        this.lock.lockWrite();
        super.reverse();
        this.lock.unlockWrite();
    }

    public void shuffle() {
        this.lock.lockWrite();
        super.shuffle();
        this.lock.unlockWrite();
    }

    public void truncate(int newSize) {
        this.lock.lockWrite();
        super.truncate(newSize);
        this.lock.unlockWrite();
    }

    public float random() {
        this.lock.lockRead();
        float f = super.random();
        this.lock.unlockRead();
        return f;
    }

    public float[] toArray() {
        this.lock.lockRead();
        float[] f = super.toArray();
        this.lock.unlockRead();
        return f;
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        boolean b = super.equals(object);
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return b;
    }

    public boolean equals(Object object, float epsilon) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        boolean b = super.equals(object, epsilon);
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

