/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.IntArray;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentIntArray
extends IntArray
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentIntArray() {
    }

    public ConcurrentIntArray(int capacity) {
        super(capacity);
    }

    public ConcurrentIntArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public ConcurrentIntArray(IntArray array) {
        super(array);
    }

    public ConcurrentIntArray(int[] array) {
        super(array);
    }

    public ConcurrentIntArray(boolean ordered, int[] array, int startIndex, int count) {
        super(ordered, array, startIndex, count);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void add(int value) {
        this.lock.lockWrite();
        super.add(value);
        this.lock.unlockWrite();
    }

    public void add(int value1, int value2) {
        this.lock.lockWrite();
        super.add(value1, value2);
        this.lock.unlockWrite();
    }

    public void add(int value1, int value2, int value3) {
        this.lock.lockWrite();
        super.add(value1, value2, value3);
        this.lock.unlockWrite();
    }

    public void add(int value1, int value2, int value3, int value4) {
        this.lock.lockWrite();
        super.add(value1, value2, value3, value4);
        this.lock.unlockWrite();
    }

    public void addAll(IntArray array, int offset, int length) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
    }

    public void addAll(int[] array, int offset, int length) {
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
    }

    public int get(int index) {
        this.lock.lockRead();
        int i = super.get(index);
        this.lock.unlockRead();
        return i;
    }

    public void set(int index, int value) {
        this.lock.lockWrite();
        super.set(index, value);
        this.lock.unlockWrite();
    }

    public void incr(int index, int value) {
        this.lock.lockWrite();
        super.incr(index, value);
        this.lock.unlockWrite();
    }

    public void mul(int index, int value) {
        this.lock.lockWrite();
        super.mul(index, value);
        this.lock.unlockWrite();
    }

    public void insert(int index, int value) {
        this.lock.lockWrite();
        super.insert(index, value);
        this.lock.unlockWrite();
    }

    public void swap(int first, int second) {
        this.lock.lockWrite();
        super.swap(first, second);
        this.lock.unlockWrite();
    }

    public boolean contains(int value) {
        this.lock.lockRead();
        boolean b = super.contains(value);
        this.lock.unlockRead();
        return b;
    }

    public int indexOf(int value) {
        this.lock.lockRead();
        int i = super.indexOf(value);
        this.lock.unlockRead();
        return i;
    }

    public int lastIndexOf(int value) {
        this.lock.lockRead();
        int i = super.lastIndexOf(value);
        this.lock.unlockRead();
        return i;
    }

    public boolean removeValue(int value) {
        this.lock.lockWrite();
        boolean b = super.removeValue(value);
        this.lock.unlockWrite();
        return b;
    }

    public int removeIndex(int index) {
        this.lock.lockWrite();
        int i = super.removeIndex(index);
        this.lock.unlockWrite();
        return i;
    }

    public void removeRange(int start, int end) {
        this.lock.lockWrite();
        super.removeRange(start, end);
        this.lock.unlockWrite();
    }

    public boolean removeAll(IntArray array) {
        this.lock.lockWrite();
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        boolean b = super.removeAll(array);
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
        this.lock.lockWrite();
        return b;
    }

    public int pop() {
        this.lock.lockWrite();
        int i = super.pop();
        this.lock.unlockWrite();
        return i;
    }

    public int peek() {
        this.lock.lockRead();
        int i = super.peek();
        this.lock.unlockRead();
        return i;
    }

    public int first() {
        this.lock.lockRead();
        int i = super.first();
        this.lock.unlockRead();
        return i;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public int[] shrink() {
        this.lock.lockWrite();
        int[] i = super.shrink();
        this.lock.unlockWrite();
        return i;
    }

    public int[] ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        int[] i = super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
        return i;
    }

    public int[] setSize(int newSize) {
        this.lock.lockWrite();
        int[] i = super.setSize(newSize);
        this.lock.unlockWrite();
        return i;
    }

    public void sort() {
        this.lock.lockWrite();
        super.sort();
        this.lock.unlockWrite();
    }

    public void reverse() {
        this.lock.lockWrite();
        super.reverse();
        this.lock.unlockWrite();
    }

    public void shuffle() {
        this.lock.lockWrite();
        super.shuffle();
        this.lock.unlockWrite();
    }

    public void truncate(int newSize) {
        this.lock.lockWrite();
        super.truncate(newSize);
        this.lock.unlockWrite();
    }

    public int random() {
        this.lock.lockRead();
        int i = super.random();
        this.lock.unlockRead();
        return i;
    }

    public int[] toArray() {
        this.lock.lockRead();
        int[] i = super.toArray();
        this.lock.unlockRead();
        return i;
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        boolean b = super.equals(object);
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

