/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.IntFloatMap;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentIntFloatMap
extends IntFloatMap
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentIntFloatMap() {
    }

    public ConcurrentIntFloatMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentIntFloatMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentIntFloatMap(IntFloatMap map) {
        super(map);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void put(int key, float value) {
        this.lock.lockWrite();
        super.put(key, value);
        this.lock.unlockWrite();
    }

    public boolean putIfAbsent(int key, float value) {
        boolean result = false;
        this.lock.lockWrite();
        if (!super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public boolean putIfPresent(int key, float value) {
        boolean result = false;
        this.lock.lockWrite();
        if (super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public float put(int key, float value, float defaultValue) {
        this.lock.lockWrite();
        float result = super.put(key, value, defaultValue);
        this.lock.unlockWrite();
        return result;
    }

    public void putAll(IntFloatMap map) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().unlockRead();
        }
    }

    public float get(int key, float defaultValue) {
        this.lock.lockRead();
        float f = super.get(key, defaultValue);
        this.lock.unlockRead();
        return f;
    }

    public float getAndIncrement(int key, float defaultValue, float increment) {
        this.lock.lockWrite();
        float f = super.getAndIncrement(key, defaultValue, increment);
        this.lock.unlockWrite();
        return f;
    }

    public float remove(int key, float defaultValue) {
        this.lock.lockWrite();
        float f = super.remove(key, defaultValue);
        this.lock.unlockWrite();
        return f;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean containsValue(float value) {
        this.lock.lockRead();
        boolean b = super.containsValue(value);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsValue(float value, float epsilon) {
        this.lock.lockRead();
        boolean b = super.containsValue(value, epsilon);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsKey(int key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    public int findKey(float value, int notFound) {
        this.lock.lockRead();
        int i = super.findKey(value, notFound);
        this.lock.unlockRead();
        return i;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public IntFloatMap.Entries entries() {
        return new IntFloatMap.Entries((IntFloatMap)this);
    }

    public IntFloatMap.Values values() {
        return new IntFloatMap.Values((IntFloatMap)this);
    }

    public IntFloatMap.Keys keys() {
        return new IntFloatMap.Keys((IntFloatMap)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

