/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.IntIntMap;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentIntIntMap
extends IntIntMap
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentIntIntMap() {
    }

    public ConcurrentIntIntMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentIntIntMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentIntIntMap(IntIntMap map) {
        super(map);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void put(int key, int value) {
        this.lock.lockWrite();
        super.put(key, value);
        this.lock.unlockWrite();
    }

    public boolean putIfAbsent(int key, int value) {
        boolean result = false;
        this.lock.lockWrite();
        if (!super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public boolean putIfPresent(int key, int value) {
        boolean result = false;
        this.lock.lockWrite();
        if (super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public int put(int key, int value, int defaultValue) {
        this.lock.lockWrite();
        int result = super.put(key, value, defaultValue);
        this.lock.unlockWrite();
        return result;
    }

    public void putAll(IntIntMap map) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().unlockRead();
        }
    }

    public int get(int key, int defaultValue) {
        this.lock.lockRead();
        int i = super.get(key, defaultValue);
        this.lock.unlockRead();
        return i;
    }

    public int getAndIncrement(int key, int defaultValue, int increment) {
        this.lock.lockWrite();
        int i = super.getAndIncrement(key, defaultValue, increment);
        this.lock.unlockWrite();
        return i;
    }

    public int remove(int key, int defaultValue) {
        this.lock.lockWrite();
        int i = super.remove(key, defaultValue);
        this.lock.unlockWrite();
        return i;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean containsValue(int value) {
        this.lock.lockRead();
        boolean b = super.containsValue(value);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsKey(int key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    public int findKey(int value, int notFound) {
        this.lock.lockRead();
        int i = super.findKey(value, notFound);
        this.lock.unlockRead();
        return i;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public IntIntMap.Entries entries() {
        return new IntIntMap.Entries((IntIntMap)this);
    }

    public IntIntMap.Values values() {
        return new IntIntMap.Values((IntIntMap)this);
    }

    public IntIntMap.Keys keys() {
        return new IntIntMap.Keys((IntIntMap)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

